const profileButton = document.getElementById('profile-button'); const profileDropdown = document.getElementById('profile-dropdown'); const hamburgerButton = document.getElementById('hamburger-button'); const sidebar = document.getElementById('sidebar'); const sidebarOverlay = document.getElementById('sidebar-overlay'); const settingsMenuToggle = document.getElementById('settings-menu-toggle'); const settingsSubmenu = document.getElementById('settings-submenu'); const settingsArrow = settingsMenuToggle.querySelector('.submenu-arrow'); function closeOtherSubmenus(exceptElement) { const allSubmenus = document.querySelectorAll('.submenu'); const allArrows = document.querySelectorAll('.submenu-arrow'); const allMenuToggles = document.querySelectorAll('.sidebar-link[id$="-menu-toggle"]'); allSubmenus.forEach(submenu => { if (submenu !== exceptElement && submenu.classList.contains('open')) { submenu.classList.remove('open'); } }); allArrows.forEach(arrow => { const parentToggle = arrow.closest('button'); if (parentToggle !== exceptElement?.previousElementSibling && arrow.classList.contains('rotate-180')) { arrow.classList.remove('rotate-180'); } }); allMenuToggles.forEach(toggle => { if (toggle !== exceptElement?.previousElementSibling) { toggle.classList.remove('active'); } }); } profileButton.addEventListener('click', (e) => { e.stopPropagation(); profileDropdown.classList.toggle('open'); }); document.addEventListener('click', (event) => { if (profileDropdown.classList.contains('open') && !profileButton.contains(event.target) && !profileDropdown.contains(event.target)) { profileDropdown.classList.remove('open'); } }); hamburgerButton.addEventListener('click', (e) => { e.stopPropagation(); const isOpen = sidebar.classList.toggle('open'); sidebarOverlay.classList.toggle('opacity-100', isOpen); sidebarOverlay.classList.toggle('pointer-events-auto', isOpen); document.body.classList.toggle('overflow-hidden', isOpen); }); sidebarOverlay.addEventListener('click', () => { sidebar.classList.remove('open'); sidebarOverlay.classList.remove('opacity-100'); sidebarOverlay.classList.remove('pointer-events-auto'); document.body.classList.remove('overflow-hidden'); }); settingsMenuToggle.addEventListener('click', (e) => { e.preventDefault(); const isOpening = !settingsSubmenu.classList.contains('open'); settingsSubmenu.classList.toggle('open'); settingsArrow.classList.toggle('rotate-180'); sidebarLinks.forEach(l => l.classList.remove('active')); settingsMenuToggle.classList.toggle('active', isOpening); }); const sidebarLinks = document.querySelectorAll('.sidebar-link:not([id$="-menu-toggle"])'); const menuToggles = document.querySelectorAll('.sidebar-link[id$="-menu-toggle"]'); sidebarLinks.forEach(link => { link.addEventListener('click', function(e) { sidebarLinks.forEach(l => l.classList.remove('active')); menuToggles.forEach(t => t.classList.remove('active')); closeOtherSubmenus(null); this.classList.add('active'); if (window.innerWidth < 1024 && sidebar.classList.contains('open')) { sidebar.classList.remove('open'); sidebarOverlay.classList.remove('opacity-100'); sidebarOverlay.classList.remove('pointer-events-none'); document.body.classList.remove('overflow-hidden'); } }); }); const submenuLinks = document.querySelectorAll('.submenu a'); submenuLinks.forEach(link => { link.addEventListener('click', function() { sidebarLinks.forEach(l => l.classList.remove('active')); const parentToggle = this.closest('ul.submenu').previousElementSibling; if(parentToggle) { parentToggle.classList.add('active'); } if (window.innerWidth < 1024 && sidebar.classList.contains('open')) { sidebar.classList.remove('open'); sidebarOverlay.classList.remove('opacity-100'); sidebarOverlay.classList.remove('pointer-events-none'); document.body.classList.remove('overflow-hidden'); } }); }); document.addEventListener('DOMContentLoaded', () => { const animatedElements = document.querySelectorAll('.fade-in'); animatedElements.forEach(el => el.style.opacity = ''); });

        const carousel = document.getElementById('dashboard-carousel');
        const carouselWrapper = document.getElementById('carousel-wrapper');
        const slides = carouselWrapper.querySelectorAll('.carousel-slide');
        const prevButton = document.getElementById('carousel-prev');
        const nextButton = document.getElementById('carousel-next');
        const indicatorsContainer = document.getElementById('carousel-indicators');

        let currentSlide = 0;
        let slideInterval;
        const autoplayDelay = 5000;

        indicatorsContainer.innerHTML = ''; 
        slides.forEach((_, index) => {
            const indicator = document.createElement('button');
            indicator.classList.add('carousel-indicator');
            indicator.setAttribute('aria-label', `Go to slide ${index + 1}`);
            indicator.addEventListener('click', () => {
                goToSlide(index);
                resetAutoplay();
            });
            indicatorsContainer.appendChild(indicator);
        });

        const indicators = indicatorsContainer.querySelectorAll('.carousel-indicator');

        function goToSlide(index) {
            if (slides.length === 0) return;

            // Handle loop
            const newSlideIndex = (index + slides.length) % slides.length;
            currentSlide = newSlideIndex;

            const firstSlide = slides[0];
            const slideStyle = window.getComputedStyle(firstSlide);
            const slideMarginLeft = parseFloat(slideStyle.marginLeft);
            const slideMarginRight = parseFloat(slideStyle.marginRight);
            const slideMargin = slideMarginLeft + slideMarginRight; 
            const slideWidth = firstSlide.offsetWidth; 
            const containerWidth = carousel.offsetWidth; 

            const centerPointContainer = containerWidth / 2;
            const centerPointActiveSlide = (currentSlide * (slideWidth + slideMargin)) + (slideWidth / 2);

            const totalOffset = centerPointContainer - centerPointActiveSlide;

            carouselWrapper.style.transform = `translateX(${totalOffset}px)`;

            indicators.forEach((indicator, i) => {
                indicator.classList.toggle('active', i === currentSlide);
            });

             slides.forEach((slide, i) => {
                slide.classList.toggle('active-slide', i === currentSlide);
            });
        }

        function nextSlide() { goToSlide(currentSlide + 1); }
        function prevSlide() { goToSlide(currentSlide - 1); }
        function startAutoplay() { clearInterval(slideInterval); slideInterval = setInterval(nextSlide, autoplayDelay); }
        function stopAutoplay() { clearInterval(slideInterval); }
        function resetAutoplay() { stopAutoplay(); startAutoplay(); }

        prevButton.addEventListener('click', () => { prevSlide(); resetAutoplay(); });
        nextButton.addEventListener('click', () => { nextSlide(); resetAutoplay(); });
        carousel.addEventListener('mouseenter', stopAutoplay);
        carousel.addEventListener('mouseleave', startAutoplay);

        function initializeCarousel() {
            if (slides.length > 0 && carousel.offsetWidth > 0 && slides[0].offsetWidth > 0) {
                goToSlide(0);
                startAutoplay(); 
            } else {
                 setTimeout(initializeCarousel, 150); 
            }
        }

        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initializeCarousel);
        } else {
             setTimeout(initializeCarousel, 50); 
        }

        let resizeTimeout;
        window.addEventListener('resize', () => {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(() => {
                if (slides.length > 0) {
                    carouselWrapper.style.transition = 'none';
                    goToSlide(currentSlide);
                    setTimeout(() => {
                         carouselWrapper.style.transition = 'transform 0.5s ease-in-out';
                    }, 50);
                }
            }, 250);
        });
        
        