<?php
$pageTitle = 'Lihat Tiket';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex justify-between items-center mb-6">
        <h2 id="ticket-subject-title" class="text-xl md:text-2xl font-semibold text-gray-700 truncate">
            <i class="fas fa-ticket-alt mr-2 text-orange-500"></i> Memuat Tiket...
        </h2>
        <a href="<?php echo base_url('tickets'); ?>" class="text-sm text-blue-600 hover:underline flex-shrink-0 ml-4">&larr; Daftar Tiket</a>
    </div>

    <div id="ticket-view-message" class="mb-4 text-sm"></div>
    <div class="bg-white rounded-xl shadow-lg border border-gray-100">
        <div class="p-4 border-b border-gray-200 bg-gray-50 rounded-t-xl flex flex-col sm:flex-row justify-between items-start sm:items-center gap-2 text-xs">
            <div>
                ID Tiket: <strong id="ticket-view-id" class="text-gray-800">Memuat...</strong> |
                Status: <span id="ticket-view-status" class="px-2 py-0.5 inline-flex leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">Memuat...</span>
            </div>
            <div class="text-gray-500">
                Dibuat: <span id="ticket-view-created">Memuat...</span> |
                Update: <span id="ticket-view-updated">Memuat...</span>
            </div>
        </div>

        <div id="ticket-replies-container" class="p-4 md:p-6 space-y-4 max-h-[60vh] overflow-y-auto">
            <div class="text-center py-10 text-gray-500 italic">
                <i class="fas fa-spinner fa-spin mr-2"></i> Memuat percakapan...
            </div>
        </div>
        <div id="ticket-reply-form-container" class="p-4 border-t border-gray-200 bg-gray-50 rounded-b-xl">
             <form id="ticket-reply-form" action="<?php echo base_url('ajax/reply_ticket'); ?>" method="POST">
                 <input type="hidden" name="ticket_id" id="reply_ticket_id" value="">
                 <div class="space-y-4">
                     <div>
                         <label for="reply_message" class="block text-sm font-medium text-gray-700 mb-1">Balas Tiket <span class="text-red-500">*</span></label>
                         <textarea id="reply_message" name="message" rows="4" required
                                   placeholder="Tulis balasan Anda di sini..."
                                   class="input-field w-full px-4 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500"></textarea>
                         <span id="reply_message-error" class="text-xs text-red-500 mt-1 block"></span>
                     </div>

                     <div>
                         <label for="reply_attachment" class="block text-sm font-medium text-gray-700 mb-1">Lampiran (Opsional)</label>
                         <input type="file" id="reply_attachment" name="attachment" accept="image/jpeg, image/png, image/gif, image/webp"
                                class="input-field block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer border border-gray-300 rounded-lg p-1 focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                         <span id="reply_attachment-error" class="text-xs text-red-500 mt-1 block"></span>
                         <p class="text-xs text-gray-400 mt-1">Format: JPG, PNG, GIF, WEBP. Maks: 2MB.</p>
                     </div>
                     <div class="flex justify-between items-center">
                         <button type="submit" id="submit-reply"
                                 class="px-5 py-2 text-sm font-semibold text-white bg-blue-600 rounded-lg shadow-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                             <span id="reply-btn-text">Kirim Balasan</span>
                             <i id="reply-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
                         </button>
                         <button type="button" id="close-ticket-button" class="px-4 py-2 text-sm font-medium text-red-700 bg-red-100 border border-transparent rounded-lg hover:bg-red-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 transition hidden">
                             Tutup Tiket
                         </button>
                     </div>
                 </div>
             </form>
        </div>
        <div id="ticket-closed-message" class="p-4 border-t border-gray-200 bg-gray-100 text-center text-sm text-gray-600 rounded-b-xl hidden">
             Tiket ini telah ditutup. Anda tidak dapat mengirim balasan lagi.
         </div>
    </div>
</main>
