<?php

$pageTitle = 'Registrasi Akun Baru';
if (session_status() == PHP_SESSION_NONE) { session_start(); }
?>

<div class="flex items-center justify-center min-h-screen px-4 py-12">
    <div class="w-full max-w-md bg-white rounded-xl shadow-2xl p-8 md:p-10 login-card-animation">

        <div class="flex flex-col items-center mb-8">
            <a href="<?php echo base_url(); ?>" class="flex items-center mb-4 space-x-3">
                <span class="inline-block p-3 bg-blue-600 rounded-xl">
                    <i class="fas fa-user-plus text-white text-2xl"></i>
                </span>
                <span class="text-2xl font-bold text-gray-800"><?php echo htmlspecialchars($appName); ?> Registrasi</span>
            </a>
            <p class="text-gray-500 text-sm">Buat akun baru Anda</p>
        </div>

        <div id="register-message" class="mb-4 text-sm"></div>

        <form id="register-form" method="POST" class="space-y-5">

             <div>
                <label for="full_name" class="block text-sm font-medium text-gray-700 mb-1">
                    Nama Lengkap <span class="text-gray-500 text-xs">(Opsional)</span>
                </label>
                <div class="relative">
                     <span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none"> <i class="fas fa-user text-gray-400"></i> </span>
                    <input id="full_name" name="full_name" type="text" autocomplete="name" placeholder="Masukkan nama lengkap Anda"
                           class="input-field appearance-none block w-full pl-10 pr-3 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out" />
                    <span id="full_name-error" class="text-red-500 text-xs mt-1"></span> </div>
            </div>

            <div>
                <label for="username" class="block text-sm font-medium text-gray-700 mb-1">
                    Username <span class="text-red-500">*</span>
                </label>
                <div class="relative">
                     <span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none"> <i class="fas fa-at text-gray-400"></i> </span>
                    <input id="username" name="username" type="text" autocomplete="username" required placeholder="Pilih username unik (min. 4 karakter)"
                           class="input-field appearance-none block w-full pl-10 pr-3 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out" />
                    <span id="username-error" class="text-red-500 text-xs mt-1"></span> </div>
            </div>

            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-1">
                    Alamat Email <span class="text-red-500">*</span>
                </label>
                <div class="relative">
                     <span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none"> <i class="fas fa-envelope text-gray-400"></i> </span>
                    <input id="email" name="email" type="email" autocomplete="email" required placeholder="nama@contoh.com"
                           class="input-field appearance-none block w-full pl-10 pr-3 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out" />
                    <span id="email-error" class="text-red-500 text-xs mt-1"></span> </div>
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700 mb-1">
                    Password <span class="text-red-500">*</span>
                </label>
                 <div class="relative">
                     <span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none"> <i class="fas fa-lock text-gray-400"></i> </span>
                    <input id="password" name="password" type="password" autocomplete="new-password" required placeholder="Buat password (min. 6 karakter)"
                           class="input-field appearance-none block w-full pl-10 pr-10 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out" />
                     <button type="button" id="togglePassword" class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5 focus:outline-none">
                         <i class="fas fa-eye text-gray-400 hover:text-gray-600 cursor-pointer" aria-hidden="true"></i>
                     </button>
                     <span id="password-error" class="text-red-500 text-xs mt-1"></span> </div>
            </div>

             <div>
                <label for="confirm_password" class="block text-sm font-medium text-gray-700 mb-1">
                    Konfirmasi Password <span class="text-red-500">*</span>
                </label>
                 <div class="relative">
                     <span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none"> <i class="fas fa-check-circle text-gray-400"></i> </span>
                    <input id="confirm_password" name="confirm_password" type="password" autocomplete="new-password" required placeholder="Ketik ulang password Anda"
                           class="input-field appearance-none block w-full pl-10 pr-10 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out" />
                     <button type="button" id="toggleConfirmPassword" class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5 focus:outline-none">
                         <i class="fas fa-eye text-gray-400 hover:text-gray-600 cursor-pointer" aria-hidden="true"></i>
                     </button>
                     <span id="confirm_password-error" class="text-red-500 text-xs mt-1"></span> </div>
            </div>

            <div>
                <button type="submit" id="register-button" <?php  ?>
                        class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out transform hover:scale-105">
                    <i class="fas fa-user-plus mr-2 mt-0.5"></i> <span id="register-button-text">Daftar Sekarang</span>
                    <i id="register-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i> <?php  ?>
                </button>
            </div>
        </form>

        <p class="mt-8 text-center text-sm text-gray-600">
            Sudah punya akun?
            <a href="<?php echo base_url('login'); ?>" class="font-medium text-blue-600 hover:text-blue-700 hover:underline">
                Login di sini
            </a>
        </p>

    </div>
</div>
