<?php

$userFullname = $_SESSION['user_fullname'] ?? 'Pengguna';
$userEmail = $_SESSION['user_email'] ?? 'email@contoh.com';
$userRole = $_SESSION['user_role'] ?? 'member';
$isAdmin = ($userRole === 'admin');

$route = $route ?? trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');

$basePathForRoute = defined('BASE_URL') ? trim(parse_url(BASE_URL, PHP_URL_PATH), '/') : '';

if (!empty($basePathForRoute) && strpos($route, $basePathForRoute) === 0) {
    $currentRoute = trim(substr($route, strlen($basePathForRoute)), '/');
} else {
    $currentRoute = $route;
}
$currentRoute = $currentRoute ?: '/';

function is_active(string $routeToCheck, string $currentRoute): bool {
    if ($routeToCheck === '/' && $currentRoute === '/') return true;
    if ($routeToCheck === '/') return false;
    if (empty($routeToCheck)) return false;
    return $currentRoute === $routeToCheck || strpos($currentRoute, $routeToCheck . '/') === 0;
}

function is_submenu_active(array $routes, string $currentRoute): bool {
    foreach ($routes as $route) {
        if (is_active($route, $currentRoute)) {
            return true;
        }
    }
    return false;
}

$userOrderRoutes = ['order/create', 'order/history', 'order/report'];
$userDepositRoutes = ['deposit/new', 'deposit/history', 'deposit/report'];
$userServiceRoutes = ['services'];
$userTicketRoutes = ['tickets/create', 'tickets', 'tickets/view'];
$userBalanceRoutes = ['balance/history'];
$userSitemapRoutes = ['sitemap/contact', 'sitemap/terms', 'sitemap/status-info', 'sitemap/target-example', 'sitemap/order-tutorial', 'sitemap/download-app', 'sitemap/ig-troubleshoot', 'sitemap/privacy'];

$adminManageRoutes = ['admin/users', 'admin/orders', 'admin/deposits', 'admin/balance-logs', 'admin/login-logs', 'admin/tickets', 'admin/services', 'admin/categories', 'admin/providers', 'admin/informations', 'admin/settings'];


$isUserOrderActive = !$isAdmin && is_submenu_active($userOrderRoutes, $currentRoute);
$isUserDepositActive = !$isAdmin && is_submenu_active($userDepositRoutes, $currentRoute);
$isUserServiceActive = !$isAdmin && is_submenu_active($userServiceRoutes, $currentRoute);
$isUserTicketActive = !$isAdmin && is_submenu_active($userTicketRoutes, $currentRoute);
$isUserBalanceActive = !$isAdmin && is_submenu_active($userBalanceRoutes, $currentRoute);
$isUserSitemapActive = !$isAdmin && is_submenu_active($userSitemapRoutes, $currentRoute);

$isAdminManageActive = $isAdmin && is_submenu_active($adminManageRoutes, $currentRoute);

?>
<aside id="sidebar" class="fixed inset-y-0 left-0 z-40 w-64 bg-gradient-to-b from-blue-700 to-indigo-800 text-gray-100 shadow-xl transform transition-transform duration-300 ease-in-out lg:translate-x-0 lg:static lg:inset-0 overflow-y-auto border-r border-indigo-900">
    <div class="p-5">
        <div class="flex items-center justify-between mb-10">
            <a href="<?php echo base_url($isAdmin ? 'admin/dashboard' : 'dashboard'); ?>" class="flex items-center space-x-3">
                <span class="inline-block p-2.5 bg-white bg-opacity-20 rounded-xl">
                    <i class="fas fa-bolt text-white text-xl"></i>
                </span>
                <span class="text-xl font-bold text-white"><?php echo htmlspecialchars($appSettings['app_name'] ?? 'SMM Panel'); ?></span>
            </a>
            <button id="sidebar-close-button" class="lg:hidden text-gray-300 hover:text-white focus:outline-none">
                <i class="fas fa-times text-2xl"></i>
            </button>
        </div>

        <nav class="space-y-1.5">

            <?php if (!$isAdmin): ?>
                <p class="px-4 pt-4 pb-2 text-xs font-semibold text-blue-200 uppercase tracking-wider">Menu Utama</p>
                <a href="<?php echo base_url('dashboard'); ?>" class="flex items-center px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo (is_active('dashboard', $currentRoute) || $currentRoute === '/') ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Dashboard
                </a>
                <div>
                    <button id="pesanan-menu-toggle" class="w-full flex items-center justify-between px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo $isUserOrderActive ? 'active' : ''; ?>">
                        <span class="flex items-center"><i class="fas fa-shopping-cart w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Pesanan</span>
                        <i class="fas fa-chevron-down text-xs text-gray-400 submenu-arrow <?php echo $isUserOrderActive ? 'rotate-180' : ''; ?>"></i>
                    </button>
                    <ul id="pesanan-submenu" class="submenu <?php echo $isUserOrderActive ? 'open' : ''; ?>">
                        <li><a href="<?php echo base_url('order/create'); ?>" class="<?php echo is_active('order/create', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Pesanan Baru</a></li>
                        <li><a href="<?php echo base_url('order/history'); ?>" class="<?php echo is_active('order/history', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Riwayat Pesanan</a></li>
                        <li><a href="<?php echo base_url('order/report'); ?>" class="<?php echo is_active('order/report', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Laporan Pesanan</a></li>
                    </ul>
                </div>
                <div>
                    <button id="deposit-menu-toggle" class="w-full flex items-center justify-between px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo $isUserDepositActive ? 'active' : ''; ?>">
                        <span class="flex items-center"><i class="fas fa-wallet w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Deposit</span>
                        <i class="fas fa-chevron-down text-xs text-gray-400 submenu-arrow <?php echo $isUserDepositActive ? 'rotate-180' : ''; ?>"></i>
                    </button>
                    <ul id="deposit-submenu" class="submenu <?php echo $isUserDepositActive ? 'open' : ''; ?>">
                        <li><a href="<?php echo base_url('deposit/new'); ?>" class="<?php echo is_active('deposit/new', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Deposit Baru</a></li>
                        <li><a href="<?php echo base_url('deposit/history'); ?>" class="<?php echo is_active('deposit/history', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Riwayat Deposit</a></li>
                        <li><a href="<?php echo base_url('deposit/report'); ?>" class="<?php echo is_active('deposit/report', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Laporan Deposit</a></li>
                    </ul>
                </div>
                 <a href="<?php echo base_url('balance/history'); ?>" class="flex items-center px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo $isUserBalanceActive ? 'active' : ''; ?>">
                    <i class="fas fa-exchange-alt w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Mutasi Saldo
                </a>
                <div>
                    <button id="layanan-menu-toggle" class="w-full flex items-center justify-between px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo $isUserServiceActive ? 'active' : ''; ?>">
                        <span class="flex items-center"><i class="fas fa-list w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Layanan</span>
                        <i class="fas fa-chevron-down text-xs text-gray-400 submenu-arrow <?php echo $isUserServiceActive ? 'rotate-180' : ''; ?>"></i>
                    </button>
                    <ul id="layanan-submenu" class="submenu <?php echo $isUserServiceActive ? 'open' : ''; ?>">
                        <li><a href="<?php echo base_url('services'); ?>" class="<?php echo is_active('services', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Daftar Layanan</a></li>
                    </ul>
                </div>
                 <div>
                    <button id="tiket-menu-toggle" class="w-full flex items-center justify-between px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo $isUserTicketActive ? 'active' : ''; ?>">
                        <span class="flex items-center"><i class="fas fa-ticket-alt w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Tiket</span>
                        <i class="fas fa-chevron-down text-xs text-gray-400 submenu-arrow <?php echo $isUserTicketActive ? 'rotate-180' : ''; ?>"></i>
                    </button>
                    <ul id="tiket-submenu" class="submenu <?php echo $isUserTicketActive ? 'open' : ''; ?>">
                        <li><a href="<?php echo base_url('tickets/create'); ?>" class="<?php echo is_active('tickets/create', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Tiket Baru</a></li>
                        <li><a href="<?php echo base_url('tickets'); ?>" class="<?php echo is_active('tickets', $currentRoute) && !is_active('tickets/create', $currentRoute) && !is_active('tickets/view', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Data Tiket</a></li>
                    </ul>
                </div>
                <a href="<?php echo base_url('api-docs'); ?>" class="flex items-center px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo is_active('api-docs', $currentRoute) ? 'active' : ''; ?>">
                    <i class="fas fa-code w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Dokumentasi API
                </a>
                <a href="<?php echo base_url('profile/settings'); ?>" class="flex items-center px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo is_active('profile/settings', $currentRoute) ? 'active' : ''; ?>">
                    <i class="fas fa-user-cog w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Pengaturan Akun
                </a>

            <?php else: ?>
                <p class="px-4 pt-4 pb-2 text-xs font-semibold text-red-300 uppercase tracking-wider">Admin Panel</p>
                <a href="<?php echo base_url('admin/dashboard'); ?>" class="flex items-center px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo is_active('admin/dashboard', $currentRoute) ? 'active' : ''; ?>">
                    <i class="fas fa-shield-alt w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Admin Dashboard
                </a>
                <div>
                    <button id="admin-manage-menu-toggle" class="w-full flex items-center justify-between px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo $isAdminManageActive ? 'active' : ''; ?>">
                        <span class="flex items-center"><i class="fas fa-cogs w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Kelola Data</span>
                        <i class="fas fa-chevron-down text-xs text-gray-400 submenu-arrow <?php echo $isAdminManageActive ? 'rotate-180' : ''; ?>"></i>
                    </button>
                    <ul id="admin-manage-submenu" class="submenu <?php echo $isAdminManageActive ? 'open' : ''; ?>">
                        <li><a href="<?php echo base_url('admin/users'); ?>" class="<?php echo is_active('admin/users', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Kelola Pengguna</a></li>
                        <li><a href="<?php echo base_url('admin/orders'); ?>" class="<?php echo is_active('admin/orders', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Kelola Pesanan</a></li>
                        <li><a href="<?php echo base_url('admin/deposits'); ?>" class="<?php echo is_active('admin/deposits', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Kelola Deposit</a></li>
                        <li><a href="<?php echo base_url('admin/balance-logs'); ?>" class="<?php echo is_active('admin/balance-logs', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Mutasi Saldo</a></li>
                        <li><a href="<?php echo base_url('admin/login-logs'); ?>" class="<?php echo is_active('admin/login-logs', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Log Masuk</a></li>
                        <li><a href="<?php echo base_url('admin/tickets'); ?>" class="<?php echo is_active('admin/tickets', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Kelola Tiket</a></li>
                        <li><a href="<?php echo base_url('admin/services'); ?>" class="<?php echo is_active('admin/services', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Kelola Layanan</a></li>
                        <li><a href="<?php echo base_url('admin/categories'); ?>" class="<?php echo is_active('admin/categories', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Kelola Kategori</a></li>
                        <li><a href="<?php echo base_url('admin/providers'); ?>" class="<?php echo is_active('admin/providers', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Kelola Provider</a></li>
                        <li><a href="<?php echo base_url('admin/informations'); ?>" class="<?php echo is_active('admin/informations', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Kelola Informasi</a></li>
                        <li><a href="<?php echo base_url('admin/settings'); ?>" class="<?php echo is_active('admin/settings', $currentRoute) ? 'font-semibold text-white' : ''; ?>">Pengaturan Website</a></li>
                    </ul>
                </div>
                 <a href="<?php echo base_url('profile/settings'); ?>" class="flex items-center px-4 py-3 text-gray-200 hover:bg-white hover:bg-opacity-10 hover:text-white rounded-lg transition-all group sidebar-link <?php echo is_active('profile/settings', $currentRoute) ? 'active' : ''; ?>">
                    <i class="fas fa-user-cog w-5 h-5 mr-4 text-gray-300 group-hover:text-white transition-colors"></i> Pengaturan Akun
                </a>
            <?php endif; ?>

        </nav>
    </div>
    <div class="p-4 mt-auto border-t border-white border-opacity-10">
        <div class="flex items-center">
            <img id="sidebar-avatar-img" src="https://placehold.co/40x40/e0e7ff/4f46e5?text=<?php echo strtoupper(substr($userFullname, 0, 1)); ?>" alt="<?php echo htmlspecialchars($userFullname); ?> Avatar" class="w-10 h-10 rounded-full mr-3 border-2 border-blue-300">
            <div>
                <p class="font-medium text-sm text-white truncate" title="<?php echo htmlspecialchars($userFullname); ?>"><?php echo htmlspecialchars($userFullname); ?></p>
                <p class="text-xs text-blue-200 truncate" title="<?php echo htmlspecialchars($userEmail); ?>"><?php echo htmlspecialchars($userEmail); ?></p>
            </div>
        </div>
    </div>
</aside>
