<?php
$pageTitle = 'Laporan Pesanan';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

$defaultEndDate = date('Y-m-d');
$defaultStartDate = date('Y-m-d', strtotime('-6 days'));

$startDate = $_GET['date_start'] ?? $defaultStartDate;
$endDate = $_GET['date_end'] ?? $defaultEndDate;

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-chart-line mr-3 text-blue-500"></i> Laporan Pesanan
        </h2>
    </div>

    <div class="bg-white p-4 rounded-xl shadow-md mb-6 border border-gray-100">
        <form id="report-filter-form" class="flex flex-col sm:flex-row items-end gap-4">
            <div>
                <label for="report_date_start" class="block text-xs font-medium text-gray-600 mb-1">Tanggal Mulai</label>
                <input type="date" id="report_date_start" name="date_start" value="<?php echo htmlspecialchars($startDate); ?>"
                       class="w-full sm:w-auto px-3 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div class="text-center pt-5 hidden sm:block">
                 <span class="text-gray-500">sampai</span>
            </div>
            <div>
                <label for="report_date_end" class="block text-xs font-medium text-gray-600 mb-1">Tanggal Akhir</label>
                <input type="date" id="report_date_end" name="date_end" value="<?php echo htmlspecialchars($endDate); ?>"
                       class="w-full sm:w-auto px-3 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div class="flex-grow"></div> <button type="submit" id="apply-report-filter"
                    class="w-full sm:w-auto px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">
                <span id="report-filter-btn-text">Tampilkan Laporan</span>
                <i id="report-filter-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
            </button>
        </form>
    </div>

     <div id="report-message" class="mb-4 text-sm"></div>

    <div class="bg-white p-4 md:p-6 rounded-xl shadow-lg mb-6 border border-gray-100">
        <h3 class="text-lg font-semibold text-gray-700 mb-4">Grafik Pesanan Harian</h3>
        <div id="order-chart-container" class="relative h-72 md:h-96">
            <canvas id="orderChart"></canvas>
             <div id="chart-loading-placeholder" class="absolute inset-0 flex items-center justify-center bg-white bg-opacity-75 text-gray-500 text-sm italic z-10">
                 <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data grafik...
             </div>
        </div>
    </div>

    <div class="bg-white p-4 md:p-6 rounded-xl shadow-lg border border-gray-100">
        <h3 class="text-lg font-semibold text-gray-700 mb-4">Ringkasan Status Pesanan</h3>
        <div id="status-summary-container" class="space-y-3">
            <div class="flex items-center justify-between p-3 bg-gray-100 rounded-lg text-sm text-gray-500 italic">
                 <span>Memuat ringkasan status...</span>
                 <i class="fas fa-spinner fa-spin"></i>
             </div>
        </div>
    </div>

</main>
