<?php
$pageTitle = 'Riwayat Pesanan';

if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

$initialSearchQuery = $searchQuery ?? '';
$initialStatusFilter = $statusFilter ?? 'all';
$initialLimit = $limit ?? 10;
$statusOptions = $statusOptions ?? [];
$sortColumnOptions = $sortColumnOptions ?? [];
$sortTypeOptions = $sortTypeOptions ?? [];
$searchColumnOptions = $searchColumnOptions ?? [];

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h2 class="text-2xl font-semibold text-gray-700">Riwayat Pesanan</h2>
        <div class="flex items-center space-x-2">
             <button type="button" id="filter-modal-button"
                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                <i class="fas fa-filter mr-1"></i> Filter Data
            </button>
            <a href="<?php echo base_url('order/create'); ?>"
               class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                <i class="fas fa-plus mr-1"></i> Buat Pesanan Baru
            </a>
        </div>
    </div>

    <?php display_flash_message('order_history_error'); ?>
     <div id="order-history-message" class="mb-4 text-sm"></div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Layanan</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Target</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Harga</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody id="order-history-table-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="8" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                            <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data pesanan...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
         <div id="pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
            <div id="pagination-info">
                Menampilkan 0 sampai 0 dari 0 hasil.
            </div>
            <div id="pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1">
                 <span class="px-3 py-1 border rounded bg-white text-gray-400 cursor-not-allowed">&laquo; Sebelumnya</span>
                 <span class="px-3 py-1 border rounded bg-white text-gray-400 cursor-not-allowed">Berikutnya &raquo;</span>
            </div>
        </div>
    </div>

    <div id="filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-2xl mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="filter-modal-title">
                    <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Data
                </h3>
                <button type="button" id="close-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span>
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>

            <form id="filter-form" class="p-6 space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label for="filter_limit" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                        <select id="filter_limit" name="limit" class="w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="10" <?php echo ($initialLimit == 10) ? 'selected' : ''; ?>>10 baris</option>
                            <option value="25" <?php echo ($initialLimit == 25) ? 'selected' : ''; ?>>25 baris</option>
                            <option value="50" <?php echo ($initialLimit == 50) ? 'selected' : ''; ?>>50 baris</option>
                            <option value="100" <?php echo ($initialLimit == 100) ? 'selected' : ''; ?>>100 baris</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_date_start" class="block text-sm font-medium text-gray-300 mb-1">Tanggal Mulai</label>
                        <input type="date" id="filter_date_start" name="date_start" class="w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" placeholder="YYYY-MM-DD">
                    </div>
                    <div>
                        <label for="filter_date_end" class="block text-sm font-medium text-gray-300 mb-1">Tanggal Akhir</label>
                        <input type="date" id="filter_date_end" name="date_end" class="w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500" placeholder="YYYY-MM-DD">
                    </div>
                </div>
                <div>
                    <label for="filter_status" class="block text-sm font-medium text-gray-300 mb-1">Filter Status</label>
                    <select id="filter_status" name="status" class="w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                        <?php foreach ($statusOptions as $value => $label): ?>
                            <option value="<?php echo $value; ?>" <?php echo ($initialStatusFilter === $value) ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($label); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_sort_by" class="block text-sm font-medium text-gray-300 mb-1">Kolom Sortir</label>
                        <select id="filter_sort_by" name="sort_by" class="w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($sortColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'o.created_at') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_sort_type" class="block text-sm font-medium text-gray-300 mb-1">Tipe Sortir</label>
                        <select id="filter_sort_type" name="sort_type" class="w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($sortTypeOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'DESC') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                     <div>
                        <label for="filter_search_column" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                        <select id="filter_search_column" name="search_column" class="w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($searchColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_search_keyword" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci Cari</label>
                        <input type="text" id="filter_search_keyword" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchQuery); ?>" placeholder="Masukkan kata kunci..."
                               class="w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                 </div>

                 <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                     <button type="button" id="reset-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">
                         Reset
                     </button>
                     <button type="submit" id="apply-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition">
                         <i class="fas fa-filter mr-1"></i> Terapkan Filter
                     </button>
                 </div>
            </form>
        </div>
    </div>

    <div id="order-detail-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="order-detail-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-lg mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="order-detail-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="order-detail-modal-title">
                    <i class="fas fa-info-circle mr-2 text-blue-400"></i> Detail Pesanan #<span id="detail-order-id"></span>
                </h3>
                <button type="button" id="close-order-detail-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span>
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>

            <div class="p-6 space-y-3 text-sm" id="order-detail-modal-body">
                <div class="flex justify-center items-center h-32">
                    <i class="fas fa-spinner fa-spin text-3xl text-gray-400"></i>
                </div>
            </div>

             <div class="px-6 py-3 bg-gray-700 rounded-b-lg flex justify-end">
                 <button type="button" id="close-order-detail-modal-footer" class="px-4 py-2 text-sm font-medium text-gray-200 bg-red-600 rounded-lg hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-red-500 transition">
                     Tutup
                 </button>
             </div>
        </div>
    </div>

</main>
