<?php

$pageTitle = 'Login Admin';
if (session_status() == PHP_SESSION_NONE) { session_start(); }
?>

<div class="flex items-center justify-center min-h-screen px-4 py-12">
    <div class="w-full max-w-md bg-white rounded-xl shadow-2xl p-8 md:p-10 login-card-animation">

        <div class="flex flex-col items-center mb-8">
            <a href="<?php echo base_url(); ?>" class="flex items-center mb-4 space-x-3">
                <span class="inline-block p-3 bg-blue-600 rounded-xl">
                    <i class="fas fa-bolt text-white text-2xl"></i>
                </span>
                <span class="text-2xl font-bold text-gray-800"><?php echo htmlspecialchars($appName); ?> - Login</span>
            </a>
            <p class="text-gray-500 text-sm">Silakan masuk untuk melanjutkan</p>
        </div>

        <div id="login-message" class="mb-4 text-sm"></div>

        <?php
         if (isset($_SESSION['register_success'])) {
             echo '<div class="mb-4 p-3 bg-green-100 text-green-700 border border-green-300 rounded-lg text-sm" role="alert">';
             echo htmlspecialchars($_SESSION['register_success']);
             echo '</div>';
             unset($_SESSION['register_success']);
         }
        ?>

        <form id="login-form" method="POST" class="space-y-6">
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-1">
                    Alamat Email atau Username <span class="text-red-500">*</span>
                </label>
                <div class="relative">
                     <span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <i class="fas fa-envelope text-gray-400"></i>
                    </span>
                    <input
                        id="email" <?php ?>
                        name="email"
                        type="text"
                        autocomplete="username"
                        required
                        placeholder="Username atau email Anda"
                        class="input-field appearance-none block w-full pl-10 pr-3 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out"
                    />
                     <span id="email-error" class="text-red-500 text-xs mt-1"></span> </div>
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700 mb-1">
                    Password <span class="text-red-500">*</span>
                </label>
                 <div class="relative">
                     <span class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <i class="fas fa-lock text-gray-400"></i>
                    </span>
                    <input
                        id="password" <?php ?>
                        name="password"
                        type="password"
                        autocomplete="current-password"
                        required
                        placeholder="Masukkan password Anda"
                        class="input-field appearance-none block w-full pl-10 pr-10 py-2.5 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm transition duration-150 ease-in-out"
                    />
                     <button type="button" id="togglePassword" class="absolute inset-y-0 right-0 pr-3 flex items-center text-sm leading-5 focus:outline-none">
                         <i class="fas fa-eye text-gray-400 hover:text-gray-600 cursor-pointer" aria-hidden="true"></i>
                     </button>
                     <span id="password-error" class="text-red-500 text-xs mt-1"></span> </div>
            </div>

            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <input id="remember-me" name="remember-me" type="checkbox" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded" />
                    <label for="remember-me" class="ml-2 block text-sm text-gray-800"> Ingat saya </label>
                </div>
                <div class="text-sm">
                    <a href="<?php echo base_url('forgot-password'); ?>" class="font-medium text-blue-600 hover:text-blue-700 hover:underline"> Lupa password? </a>
                </div>
            </div>

            <div>
                <button type="submit" id="login-button" <?php  ?>
                        class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out transform hover:scale-105">
                    <i class="fas fa-sign-in-alt mr-2 mt-0.5"></i> <span id="login-button-text">Login</span>
                    <i id="login-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i> <?php ?>
                </button>
            </div>
        </form>

        <p class="mt-8 text-center text-sm text-gray-600">
            Belum punya akun?
            <a href="<?php echo base_url('register'); ?>" class="font-medium text-blue-600 hover:text-blue-700 hover:underline">
                Daftar sekarang
            </a>
        </p>

    </div>
</div>
