<?php

$pageTitle = htmlspecialchars($appSettings['app_name'] ?? 'SMM Panel');

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle) - htmlspecialchars($appSettings['app_name']); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo base_url('assets/css/style.css'); ?>">
    <style>
        body { font-family: 'Poppins', sans-serif; }
    </style>
</head>
<body class="bg-gray-100">

    <?php
        $navbarPath = TEMPLATE_DIR . '/partials/navbar.php'; 
        if (file_exists($navbarPath)) {
            include $navbarPath;
        }
    ?>

    <main class="py-5">
        <?php
        if (isset($contentView) && file_exists($contentView)) {
            include $contentView;
        } else {
            echo "<div class='container mx-auto p-8'><p class='text-center text-red-500'>Error: Konten halaman tidak dapat dimuat.</p></div>";
        }
        ?>
    </main>

    <?php
        $footerPath = TEMPLATE_DIR . '/partials/footer.php'; 
        if (file_exists($footerPath)) {
            include $footerPath;
        }
    ?>

    <script src="<?php echo base_url('assets/js/script.js'); ?>"></script>
    </body>
</html>
