<?php
global $appSettings; 
$currentAppName = htmlspecialchars($appSettings['app_name'] ?? 'SMM Panel Anda');
$pageTitle = '404 - Halaman Tidak Ditemukan'; 

if (!isset($appSettings['contact_email'])) {
    $appSettings['contact_email'] = 'support@example.com'; 
}

if (!function_exists('base_url')) {
    function base_url($path = '') {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        $script_dir = str_replace(basename($_SERVER['SCRIPT_NAME']), '', $_SERVER['SCRIPT_NAME']);
        $base = rtrim($protocol . $host . $script_dir, '/');
        return $base . '/' . ltrim($path, '/');
    }
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle . ' - ' . $currentAppName; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { 
            font-family: 'Poppins', sans-serif;
            background-color: #0F172A; /* bg-slate-900 */
            color: #E2E8F0; /* text-gray-100 */
        }
        .gradient-text-404 {
            background: linear-gradient(to right, #A855F7, #EC4899, #F97316); /* purple-500, pink-500, orange-500 */
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .pulse-shadow-404 {
            box-shadow: 0 0 0 0 rgba(129, 140, 248, 0.0); /* indigo-400 with 0 opacity */
            animation: pulse-shadow-animation-404 2.5s infinite cubic-bezier(0.66, 0, 0, 1);
        }
        @keyframes pulse-shadow-animation-404 {
            0% { box-shadow: 0 0 0 0px rgba(165, 180, 252, 0.5); } /* indigo-300 (tailwind) */
            70% { box-shadow: 0 0 0 20px rgba(165, 180, 252, 0); }
            100% { box-shadow: 0 0 0 0px rgba(165, 180, 252, 0); }
        }
        @keyframes bounce-404 {
          0%, 100% {
            transform: translateY(-5%);
            animation-timing-function: cubic-bezier(0.8,0,1,1);
          }
          50% {
            transform: none;
            animation-timing-function: cubic-bezier(0,0,0.2,1);
          }
        }
        .animate-bounce-404 {
          animation: bounce-404 2s infinite;
        }
        @keyframes pulse-dash-404 {
          0% { stroke-dashoffset: 0; }
          50% { stroke-dashoffset: 20; }
          100% { stroke-dashoffset: 0; }
        }
        .animate-pulse-dash-404 {
            animation: pulse-dash-404 2s infinite linear;
        }
    </style>
</head>
<body>
    <div class="min-h-screen flex flex-col items-center justify-center text-center px-4 py-12 bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900">
        <div class="max-w-lg w-full">
            
            <div class="mb-8 text-purple-400">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-32 w-32 md:h-40 md:w-40 mx-auto animate-bounce-404" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-3 8a9 9 0 11-6-16.5M12 17.5a9 9 0 100-15" />
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 17.5a9 9 0 100-15" />
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 10h.01M15 10h.01" />
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 17.5a9 9 0 100-15" opacity="0.4"/>
                    <circle cx="9.01" cy="10.01" r="0.5" fill="currentColor" opacity="0.6"/>
                    <circle cx="15.01" cy="10.01" r="0.5" fill="currentColor" opacity="0.6"/>
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9.172 16.172a4 4 0 015.656 0" stroke-dasharray="5 5" class="animate-pulse-dash-404"/>
                </svg>
            </div>

            <h1 class="text-6xl md:text-8xl font-extrabold mb-4">
                <span class="gradient-text-404">
                    404
                </span>
            </h1>
            <h2 class="text-2xl md:text-3xl font-semibold text-gray-100 mb-3">Oops! Halaman Hilang.</h2>
            <p class="text-md md:text-lg text-gray-400 mb-10 leading-relaxed">
                Maaf, kami tidak dapat menemukan halaman yang Anda cari. Mungkin halaman tersebut telah dipindahkan, dihapus, atau Anda salah mengetik URL.
            </p>

            <div class="space-y-4 sm:space-y-0 sm:flex sm:justify-center sm:space-x-4">
                <a href="<?php echo base_url(); ?>"
                   class="w-full sm:w-auto inline-flex items-center justify-center px-8 py-3.5 border border-transparent text-base font-medium rounded-xl text-white bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-slate-900 focus:ring-indigo-500 shadow-lg transform transition-all duration-150 ease-in-out hover:scale-105 pulse-shadow-404">
                    <i class="fas fa-home mr-2.5"></i>
                    Kembali ke Beranda
                </a>
                <button onclick="window.history.back()"
                        class="w-full sm:w-auto inline-flex items-center justify-center px-8 py-3.5 border border-purple-500 text-base font-medium rounded-xl text-purple-300 hover:bg-purple-500 hover:text-white focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-slate-900 focus:ring-purple-500 shadow-md transition-all duration-150 ease-in-out hover:scale-105">
                    <i class="fas fa-arrow-left mr-2.5"></i>
                    Kembali
                </button>
            </div>
            
            <p class="mt-12 text-xs text-gray-500">
                Jika Anda yakin ini adalah kesalahan, silakan hubungi <a href="mailto:<?php echo htmlspecialchars($appSettings['contact_email'] ?? 'support@example.com'); ?>" class="text-gray-400 hover:text-purple-300 underline">dukungan kami</a>.
            </p>
            <p class="mt-2 text-xs text-gray-600">&copy; <?php echo date("Y"); ?> <?php echo $currentAppName; ?>. Semua hak dilindungi.</p>
        </div>
    </div>
</body>
</html>