<?php
$pageTitle = 'Laporan Deposit';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

$defaultEndDate = date('Y-m-d');
$defaultStartDate = date('Y-m-d', strtotime('-6 days'));

$startDate = $_GET['date_start'] ?? $defaultStartDate;
$endDate = $_GET['date_end'] ?? $defaultEndDate;

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-4 md:p-8 bg-gray-900 text-gray-200 min-h-screen">
    <div class="max-w-7xl mx-auto">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-2xl sm:text-3xl font-bold text-white flex items-center">
                <i class="fas fa-chart-pie mr-3 text-emerald-400"></i> Laporan Deposit
            </h2>
        </div>

        <div class="bg-gray-800 border border-gray-700 p-4 sm:p-6 rounded-xl shadow-lg mb-8">
            <form id="deposit-report-filter-form" class="flex flex-col sm:flex-row items-end gap-4">
                <div>
                    <label for="report_deposit_date_start" class="block text-xs font-medium text-gray-400 mb-1">Tanggal Mulai</label>
                    <input type="date" id="report_deposit_date_start" name="date_start" value="<?php echo htmlspecialchars($startDate); ?>"
                           class="w-full sm:w-auto px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 transition-colors">
                </div>
                <div class="text-center pt-5 hidden sm:block">
                     <span class="text-gray-500 text-sm">&ndash;</span>
                </div>
                <div>
                    <label for="report_deposit_date_end" class="block text-xs font-medium text-gray-400 mb-1">Tanggal Akhir</label>
                    <input type="date" id="report_deposit_date_end" name="date_end" value="<?php echo htmlspecialchars($endDate); ?>"
                           class="w-full sm:w-auto px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-emerald-500 focus:border-emerald-500 transition-colors">
                </div>
                <div class="flex-grow"></div>
                <button type="submit" id="apply-deposit-report-filter"
                        class="w-full sm:w-auto px-6 py-2.5 text-sm font-medium text-white bg-gradient-to-r from-emerald-500 to-green-500 rounded-lg shadow-md hover:from-emerald-600 hover:to-green-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-emerald-500 transition-all duration-150 transform hover:scale-105">
                    <span id="deposit-report-filter-btn-text">Tampilkan Laporan</span>
                    <i id="deposit-report-filter-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
                </button>
            </form>
        </div>

         <div id="deposit-report-message" class="mb-6 text-sm"></div>

        <div class="bg-gray-800 border border-gray-700 p-4 sm:p-6 rounded-xl shadow-lg mb-8">
            <h3 class="text-lg font-semibold text-gray-100 mb-5">Grafik Deposit Harian (Sukses)</h3>
            <div id="deposit-chart-container" class="relative h-72 md:h-96">
                <canvas id="depositChart"></canvas>
                 <div id="deposit-chart-loading-placeholder" class="absolute inset-0 flex items-center justify-center bg-gray-800 bg-opacity-75 text-gray-400 text-sm italic z-10">
                     <i class="fas fa-spinner fa-spin mr-2 text-xl"></i> Memuat data grafik...
                 </div>
            </div>
        </div>

        <div class="bg-gray-800 border border-gray-700 p-4 sm:p-6 rounded-xl shadow-lg">
            <h3 class="text-lg font-semibold text-gray-100 mb-5">Ringkasan Status Deposit</h3>
            <div id="deposit-status-summary-container" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                <div class="col-span-full flex items-center justify-center p-6 bg-gray-700 rounded-lg text-sm text-gray-400 italic">
                     <span>Memuat ringkasan status...</span>
                     <i class="fas fa-spinner fa-spin ml-2"></i>
                 </div>
            </div>
        </div>
    </div>
</main>
