<?php
$pageTitle = 'Deposit Baru';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }
$paymentTypes = $paymentTypes ?? [];
$userBalance = $userBalance ?? 0;
?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-4 md:p-8 bg-gray-100">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
        <h2 class="text-xl sm:text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-wallet mr-3 text-green-500"></i> Deposit Baru
        </h2>
        <div class="text-xs sm:text-sm font-medium text-gray-600 mt-2 sm:mt-0">
            Saldo Anda: <span class="font-semibold text-green-600">Rp <?php echo number_format($userBalance, 0, ',', '.'); ?></span>
        </div>
    </div>

    <div id="deposit-message" class="mb-6 text-sm"></div>
    <div id="deposit-payment-details" class="mb-6"></div>

    <form id="deposit-form" action="<?php echo base_url('ajax/request_deposit'); ?>" method="POST">
        <div class="bg-white p-4 sm:p-6 rounded-xl shadow-lg border border-gray-100">

            <div class="mb-6">
                <label for="payment_type" class="block text-sm font-medium text-gray-700 mb-2">Pilih Jenis Pembayaran</label>
                <div class="relative">
                    <select id="payment_type" name="payment_type" class="w-full appearance-none px-4 py-2.5 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 bg-white">
                        <option value="all" selected>Tampilkan Semua Metode</option>
                        <?php foreach ($paymentTypes as $typeCode => $typeName): ?>
                            <option value="<?php echo htmlspecialchars($typeCode); ?>"><?php echo htmlspecialchars($typeName); ?></option>
                        <?php endforeach; ?>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-3 text-gray-700">
                        <i class="fas fa-chevron-down text-xs"></i>
                    </div>
                </div>
            </div>

            <p class="text-sm font-medium text-gray-700 mb-2">Pilih Metode Pembayaran</p>
            <div id="deposit-methods-outer-container" class="mb-8 -mx-1">
                <div id="deposit-methods-grid" class="grid grid-cols-2 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-3 px-1">
                    <div class="col-span-full text-center py-10 text-gray-500 italic">
                        <i class="fas fa-spinner fa-spin mr-2"></i> Memuat metode pembayaran...
                    </div>
                </div>
            </div>


            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 border-t border-gray-200 pt-6">
                <div class="md:col-span-1">
                    <label for="min_deposit_info" class="block text-xs font-medium text-gray-500 uppercase mb-1">Minimal Deposit</label>
                    <p id="min_deposit_info" class="text-lg font-semibold text-gray-800">Rp 10.000</p>
                    <input type="hidden" id="selected_method_min" value="10000">
                </div>
                <div class="md:col-span-1">
                    <label for="bonus_info" class="block text-xs font-medium text-gray-500 uppercase mb-1">Bonus Deposit</label>
                    <p id="bonus_info" class="text-lg font-semibold text-green-600">0%</p>
                     <input type="hidden" id="selected_method_bonus" value="0">
                     <input type="hidden" id="selected_method_rate" value="1">
                </div>
                 <div class="md:col-span-1">
                     <label for="deposit_amount" class="block text-sm font-medium text-gray-700 mb-1">Jumlah Deposit</label>
                     <div class="relative">
                         <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-500 text-sm">Rp</span>
                         <input type="number" id="deposit_amount" name="amount" min="10000" required placeholder="Masukkan jumlah" class="w-full pl-8 pr-3 py-2 text-sm border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500 [appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none">
                     </div>
                      <span id="deposit_amount-error" class="text-xs text-red-500 mt-1 block"></span>
                 </div>
            </div>

             <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-4 items-end">
                 <div class="md:col-span-2">
                      <label for="received_balance" class="block text-xs font-medium text-gray-500 uppercase mb-1">Saldo Diterima</label>
                      <p id="received_balance" class="text-xl font-bold text-blue-600">Rp 0</p>
                 </div>
                 <div class="md:col-span-1">
                     <input type="hidden" id="selected_method_code" name="method_code" value="">
                     <button type="submit" id="submit-deposit" disabled class="w-full px-6 py-3 text-sm font-semibold text-white bg-blue-600 rounded-lg shadow-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out disabled:opacity-50 disabled:cursor-not-allowed">
                         <span id="deposit-btn-text">Pilih Metode</span>
                         <i id="deposit-spinner" class="fas fa-spinner fa-spin ml-2 hidden"></i>
                     </button>
                 </div>
             </div>

        </div>
    </form>
</main>
<style>
    #deposit-methods-grid.scroll-x {
        display: flex;
        flex-wrap: nowrap;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch; 
        scrollbar-width: thin; 
        scrollbar-color: #a0aec0 #edf2f7; 
    }

    #deposit-methods-grid.scroll-x::-webkit-scrollbar {
        height: 6px;
    }

    #deposit-methods-grid.scroll-x::-webkit-scrollbar-track {
        background: #edf2f7;
        border-radius: 3px;
    }

    #deposit-methods-grid.scroll-x::-webkit-scrollbar-thumb {
        background: #a0aec0; 
        border-radius: 3px;
    }
    #deposit-methods-grid.scroll-x::-webkit-scrollbar-thumb:hover {
        background: #718096; 
    }

    #deposit-methods-grid.scroll-x .deposit-method-card {
        flex: 0 0 auto; 
        width: calc(50% - 0.5rem); 
        min-width: 140px; 
        margin-right: 0.75rem; 
    }
    #deposit-methods-grid.scroll-x .deposit-method-card:last-child {
        margin-right: 0;
    }

    @media (min-width: 640px) { 
        #deposit-methods-grid.scroll-x .deposit-method-card {
            width: calc(33.3333% - 0.66rem); 
        }
    }
</style>
