<?php
$pageTitle = 'Riwayat Deposit';
if (!Auth::isLoggedIn()) { redirect(base_url('login')); }

$initialStatusFilter = $_GET['status'] ?? 'all';
$initialSearchQuery = $_GET['search_keyword'] ?? '';
$initialLimit = $_GET['limit'] ?? 10;
$initialDateStart = $_GET['date_start'] ?? '';
$initialDateEnd = $_GET['date_end'] ?? '';

$depositStatusOptions = [
    'all' => 'Semua Status',
    'pending' => 'Pending',
    'success' => 'Success',
    'failed' => 'Failed',
    'expired' => 'Expired',
    'canceled' => 'Canceled'
];
$depositSortColumnOptions = [
    'd.created_at' => 'Tanggal',
    'd.deposit_id' => 'ID Deposit',
    'dm.name' => 'Metode',
    'd.amount' => 'Jumlah',
    'd.status' => 'Status'
];
$depositSortTypeOptions = ['DESC' => 'Terbaru/Tertinggi', 'ASC' => 'Terlama/Terendah'];

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-4 md:p-8 bg-gray-900 text-gray-200 min-h-screen">
    <div class="max-w-7xl mx-auto">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8">
            <h2 class="text-2xl sm:text-3xl font-bold text-white flex items-center">
                <i class="fas fa-history mr-3 text-cyan-400"></i> Riwayat Deposit
            </h2>
            <div class="flex items-center space-x-3 mt-3 sm:mt-0 w-full sm:w-auto">
                <button type="button" id="deposit-history-filter-modal-button"
                        class="w-1/2 sm:w-auto px-4 py-2 text-sm font-medium text-gray-200 bg-gray-700 border border-gray-600 rounded-lg shadow-sm hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-cyan-500 transition-colors duration-150">
                    <i class="fas fa-filter mr-2"></i> Filter
                </button>
                <a href="<?php echo base_url('deposit/new'); ?>"
                   class="w-1/2 sm:w-auto text-center px-4 py-2 text-sm font-medium text-white bg-gradient-to-r from-purple-500 to-indigo-500 rounded-lg shadow-md hover:from-purple-600 hover:to-indigo-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-purple-500 transition-all duration-150 transform hover:scale-105">
                    <i class="fas fa-plus mr-2"></i> Deposit
                </a>
            </div>
        </div>

        <div id="deposit-history-message" class="mb-6 text-sm"></div>

        <div class="bg-gray-800 shadow-xl rounded-xl overflow-hidden border border-gray-700">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead class="bg-gray-700 sticky top-0 z-10">
                        <tr>
                            <th scope="col" class="px-4 py-3.5 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">ID Deposit</th>
                            <th scope="col" class="px-4 py-3.5 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Tanggal</th>
                            <th scope="col" class="px-5 py-3.5 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Metode</th>
                            <th scope="col" class="px-4 py-3.5 text-right text-xs font-semibold text-gray-300 uppercase tracking-wider">Jumlah</th>
                            <th scope="col" class="px-4 py-3.5 text-right text-xs font-semibold text-gray-300 uppercase tracking-wider hidden sm:table-cell">Bonus</th>
                            <th scope="col" class="px-4 py-3.5 text-right text-xs font-semibold text-gray-300 uppercase tracking-wider hidden md:table-cell">Saldo Diterima</th>
                            <th scope="col" class="px-4 py-3.5 text-center text-xs font-semibold text-gray-300 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-4 py-3.5 text-center text-xs font-semibold text-gray-300 uppercase tracking-wider">Aksi</th>
                        </tr>
                    </thead>
                    <tbody id="deposit-history-table-body" class="bg-gray-800 divide-y divide-gray-700">
                        <tr>
                            <td colspan="8" class="px-6 py-16 text-center text-sm text-gray-400 italic">
                                <i class="fas fa-spinner fa-spin mr-2 text-xl"></i> Memuat riwayat deposit...
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div id="deposit-history-pagination-container" class="px-4 py-3 border-t border-gray-700 bg-gray-700 bg-opacity-50 text-xs text-gray-400 flex flex-col sm:flex-row justify-between items-center">
                <div id="deposit-history-pagination-info">Menampilkan 0 hasil.</div>
                <div id="deposit-history-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
            </div>
        </div>
    </div>

    <div id="deposit-history-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-70 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="deposit-history-filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 border border-gray-700 rounded-xl shadow-2xl w-full max-w-xl mx-auto transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="deposit-history-filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="deposit-history-filter-modal-title">
                    <i class="fas fa-filter mr-2.5 text-cyan-400"></i> Filter Riwayat Deposit
                </h3>
                <button type="button" id="close-deposit-history-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form id="deposit-history-filter-form" class="p-6 space-y-5">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div>
                        <label for="filter_deposit_limit" class="block text-sm font-medium text-gray-300 mb-1.5">Tampilkan per Halaman</label>
                        <select id="filter_deposit_limit" name="limit" class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500 transition-colors">
                            <option value="10" <?php echo ($initialLimit == 10) ? 'selected' : ''; ?>>10 baris</option>
                            <option value="25" <?php echo ($initialLimit == 25) ? 'selected' : ''; ?>>25 baris</option>
                            <option value="50" <?php echo ($initialLimit == 50) ? 'selected' : ''; ?>>50 baris</option>
                            <option value="100" <?php echo ($initialLimit == 100) ? 'selected' : ''; ?>>100 baris</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_deposit_status" class="block text-sm font-medium text-gray-300 mb-1.5">Status Deposit</label>
                        <select id="filter_deposit_status" name="status" class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500 transition-colors">
                            <?php foreach ($depositStatusOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialStatusFilter === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div>
                        <label for="filter_deposit_date_start" class="block text-sm font-medium text-gray-300 mb-1.5">Tanggal Mulai</label>
                        <input type="date" id="filter_deposit_date_start" name="date_start" value="<?php echo htmlspecialchars($initialDateStart); ?>" class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500 transition-colors">
                    </div>
                    <div>
                        <label for="filter_deposit_date_end" class="block text-sm font-medium text-gray-300 mb-1.5">Tanggal Akhir</label>
                        <input type="date" id="filter_deposit_date_end" name="date_end" value="<?php echo htmlspecialchars($initialDateEnd); ?>" class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500 transition-colors">
                    </div>
                </div>
                 <div>
                    <label for="filter_deposit_search_keyword" class="block text-sm font-medium text-gray-300 mb-1.5">Cari ID Deposit</label>
                    <input type="text" id="filter_deposit_search_keyword" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchQuery); ?>" placeholder="Masukkan ID Deposit (INV...)"
                           class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500 transition-colors">
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div>
                        <label for="filter_deposit_sort_by" class="block text-sm font-medium text-gray-300 mb-1.5">Urutkan Berdasarkan</label>
                        <select id="filter_deposit_sort_by" name="sort_by" class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500 transition-colors">
                            <?php foreach ($depositSortColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'd.created_at') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_deposit_sort_type" class="block text-sm font-medium text-gray-300 mb-1.5">Tipe Urutan</label>
                        <select id="filter_deposit_sort_type" name="sort_type" class="w-full px-3.5 py-2.5 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-cyan-500 transition-colors">
                             <?php foreach ($depositSortTypeOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'DESC') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="flex justify-end items-center pt-5 space-x-3 border-t border-gray-700 mt-6">
                     <button type="button" id="reset-deposit-history-filter-button" class="px-5 py-2.5 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition-colors duration-150">Reset</button>
                     <button type="submit" id="apply-deposit-history-filter-button" class="px-6 py-2.5 text-sm font-medium text-white bg-gradient-to-r from-cyan-500 to-blue-500 rounded-lg shadow-md hover:from-cyan-600 hover:to-blue-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-cyan-500 transition-all duration-150 transform hover:scale-105"><i class="fas fa-filter mr-2"></i> Terapkan Filter</button>
                 </div>
            </form>
        </div>
    </div>
</main>
