<?php
$pageTitle = 'Kelola Provider';
if (!Auth::isLoggedIn() || $_SESSION['user_role'] !== 'admin') { redirect(base_url('login')); }

$initialStatusFilter = $_GET['status'] ?? 'all';
$initialSearchQuery = $_GET['search'] ?? '';
$initialLimit = $_GET['limit'] ?? 15;

$statusOptionsProviders = [
    'all' => 'Semua Status',
    'active' => 'Aktif',
    'inactive' => 'Nonaktif',
];
$searchColumnOptionsProviders = [
    'id' => 'ID Provider',
    'name' => 'Nama Provider',
    'api_url' => 'API URL',
];
$sortColumnOptionsProviders = [
    'name' => 'Nama Provider',
    'id' => 'ID Provider',
    'created_at' => 'Tgl Dibuat',
    'status' => 'Status'
];
$sortTypeOptionsProviders = ['ASC' => 'A-Z / Terlama', 'DESC' => 'Z-A / Terbaru'];

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-server mr-3 text-purple-500"></i> Kelola Provider
        </h2>
        <div class="flex items-center space-x-2">
            <button type="button" id="admin-provider-filter-modal-button"
                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                <i class="fas fa-filter mr-1"></i> Filter
            </button>
            <button type="button" id="add-provider-button"
               class="px-4 py-2 text-sm font-medium text-white bg-green-600 rounded-lg shadow hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition">
                <i class="fas fa-plus mr-1"></i> Tambah Provider
            </button>
        </div>
    </div>

    <div id="admin-providers-message" class="mb-4 text-sm"></div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Provider</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">API URL</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">API ID</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Dibuat</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody id="admin-providers-table-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="7" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                            <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data provider...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
         <div id="admin-providers-pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
            <div id="admin-providers-pagination-info">Menampilkan 0 hasil.</div>
            <div id="admin-providers-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
        </div>
    </div>

    <div id="admin-provider-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="admin-provider-filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-xl mx-auto transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="admin-provider-filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="admin-provider-filter-modal-title">
                    <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Provider
                </h3>
                <button type="button" id="close-admin-provider-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form id="admin-provider-filter-form" class="p-6 space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_limit_admin_provider" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                        <select id="filter_limit_admin_provider" name="limit" class="admin-provider-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="15" <?php echo ($initialLimit == 15) ? 'selected' : ''; ?>>15 baris</option>
                            <option value="30" <?php echo ($initialLimit == 30) ? 'selected' : ''; ?>>30 baris</option>
                            <option value="50" <?php echo ($initialLimit == 50) ? 'selected' : ''; ?>>50 baris</option>
                            <option value="100" <?php echo ($initialLimit == 100) ? 'selected' : ''; ?>>100 baris</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_status_admin_provider" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                        <select id="filter_status_admin_provider" name="status" class="admin-provider-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($statusOptionsProviders as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialStatusFilter === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_search_column_admin_provider" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                        <select id="filter_search_column_admin_provider" name="search_column" class="admin-provider-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($searchColumnOptionsProviders as $value => $label): ?>
                                <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_search_keyword_admin_provider" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci</label>
                        <input type="text" id="filter_search_keyword_admin_provider" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchQuery); ?>" placeholder="Masukkan kata kunci..."
                               class="admin-provider-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_sort_by_admin_provider" class="block text-sm font-medium text-gray-300 mb-1">Urutkan</label>
                        <select id="filter_sort_by_admin_provider" name="sort_by" class="admin-provider-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($sortColumnOptionsProviders as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'name') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_sort_type_admin_provider" class="block text-sm font-medium text-gray-300 mb-1">Tipe</label>
                        <select id="filter_sort_type_admin_provider" name="sort_type" class="admin-provider-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($sortTypeOptionsProviders as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'ASC') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                    <button type="button" id="reset-admin-provider-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">Reset</button>
                    <button type="submit" id="apply-admin-provider-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition"><i class="fas fa-filter mr-1"></i> Terapkan</button>
                </div>
            </form>
        </div>
    </div>

    <div id="add-edit-provider-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="add-edit-provider-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-white rounded-xl shadow-xl w-full max-w-xl transform transition-all duration-300 ease-in-out scale-95 opacity-0 flex flex-col max-h-[90vh]" id="add-edit-provider-modal-content">
            <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t flex-shrink-0">
                <h3 id="add-edit-provider-modal-title" class="text-xl font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-plus-circle mr-3 text-green-500"></i> Tambah Provider Baru
                </h3>
                <button type="button" id="close-add-edit-provider-modal" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center">
                    <i class="fas fa-times text-xl"></i>
                    <span class="sr-only">Tutup modal</span>
                </button>
            </div>
            <div class="p-4 md:p-5 space-y-4 overflow-y-auto flex-grow">
                <form id="add-edit-provider-form" class="space-y-4">
                    <input type="hidden" id="provider_id" name="provider_id" value="">
                    <div>
                        <label for="provider_name" class="block mb-1 text-sm font-medium text-gray-700">Nama Provider <span class="text-red-500">*</span></label>
                        <input type="text" id="provider_name" name="name" required placeholder="Nama unik provider" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                        <span id="provider_name-error" class="text-red-500 text-xs mt-1"></span>
                    </div>
                    <div>
                        <label for="provider_api_url" class="block mb-1 text-sm font-medium text-gray-700">API URL <span class="text-red-500">*</span></label>
                        <input type="url" id="provider_api_url" name="api_url" required placeholder="Contoh: https://provider.com/api/" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                        <span id="provider_api_url-error" class="text-red-500 text-xs mt-1"></span>
                        <p class="text-xs text-gray-400 mt-1">Pastikan URL diakhiri dengan '/api/'.</p>
                    </div>
                    <div>
                        <label for="provider_api_id" class="block mb-1 text-sm font-medium text-gray-700">API ID (Opsional)</label>
                        <input type="text" id="provider_api_id" name="api_id" placeholder="API ID dari provider" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                        <span id="provider_api_id-error" class="text-red-500 text-xs mt-1"></span>
                    </div>
                     <div>
                        <label for="provider_api_key" class="block mb-1 text-sm font-medium text-gray-700">API Key <span class="text-red-500">*</span></label>
                        <input type="text" id="provider_api_key" name="api_key" required placeholder="API Key dari provider" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                        <span id="provider_api_key-error" class="text-red-500 text-xs mt-1"></span>
                    </div>
                     <div>
                        <label for="provider_secret_key" class="block mb-1 text-sm font-medium text-gray-700">Secret Key (Opsional)</label>
                        <input type="text" id="provider_secret_key" name="secret_key" placeholder="Secret Key jika diperlukan" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                        <span id="provider_secret_key-error" class="text-red-500 text-xs mt-1"></span>
                    </div>
                    <div>
                        <label for="provider_status" class="block mb-1 text-sm font-medium text-gray-700">Status <span class="text-red-500">*</span></label>
                        <select id="provider_status" name="status" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm bg-white focus:ring-blue-500 focus:border-blue-500">
                            <option value="active" selected>Aktif</option>
                            <option value="inactive">Nonaktif</option>
                        </select>
                        <span id="provider_status-error" class="text-red-500 text-xs mt-1"></span>
                    </div>
                    <div id="add-edit-provider-message" class="text-sm"></div>
                </form>
            </div>
            <div class="flex items-center justify-end p-4 md:p-5 space-x-3 rtl:space-x-reverse border-t border-gray-200 rounded-b flex-shrink-0">
                <button id="cancel-add-edit-provider-button" type="button" class="py-2.5 px-5 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-100">Batal</button>
                <button id="save-add-edit-provider-button" type="submit" form="add-edit-provider-form" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center">
                    Simpan Provider
                </button>
            </div>
        </div>
    </div>

    <div id="delete-provider-confirm-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="delete-provider-confirm-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-white rounded-lg shadow-xl w-full max-w-md mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="delete-provider-confirm-modal-content">
             <div class="flex items-center justify-between p-5 border-b rounded-t">
                 <h3 id="delete-provider-confirm-modal-title" class="text-xl font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-exclamation-triangle text-red-500 mr-3"></i> Konfirmasi Hapus
                 </h3>
                 <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center close-confirm-delete-provider-btn">
                     <i class="fas fa-times text-xl"></i><span class="sr-only">Tutup</span>
                 </button>
             </div>
             <div class="p-6 text-center">
                 <i class="fas fa-trash-alt text-4xl text-red-400 mb-4"></i>
                 <p id="delete-provider-confirm-modal-message" class="mb-5 text-lg font-normal text-gray-600">Apakah Anda yakin ingin menghapus provider ini?</p>
                 <p class="text-xs text-red-600 mb-4">(Menghapus provider akan gagal jika masih ada layanan yang terkait)</p>
                 <button type="button" class="text-white bg-red-600 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center mr-2" id="confirm-delete-provider-btn">
                     Ya, Hapus
                 </button>
                 <button type="button" class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 close-confirm-delete-provider-btn">
                     Batal
                 </button>
             </div>
        </div>
    </div>

</main>
