<?php
$pageTitle = 'Kelola Pesanan';

$initialStatusFilter = $_GET['status'] ?? 'all';
$initialSearchQuery = $_GET['search'] ?? '';
$initialSearchColumn = $_GET['search_column'] ?? 'o.id';
$initialLimit = $_GET['limit'] ?? 15;
$initialSortBy = $_GET['sort_by'] ?? 'o.created_at';
$initialSortType = $_GET['sort_type'] ?? 'DESC';
$initialDateStart = $_GET['date_start'] ?? '';
$initialDateEnd = $_GET['date_end'] ?? '';
$initialUserId = $_GET['user_id'] ?? '';
$initialServiceId = $_GET['service_id'] ?? '';

global $statusOptions, $sortColumnOptions, $sortTypeOptions, $searchColumnOptions;

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-tasks mr-3 text-teal-500"></i> Kelola Pesanan
        </h2>
        <div class="flex items-center space-x-2">
             <button type="button" id="admin-order-filter-modal-button"
                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                <i class="fas fa-filter mr-1"></i> Filter & Cari
            </button>
        </div>
    </div>

    <div id="admin-orders-message" class="mb-4 text-sm"></div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID Order</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pengguna</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Pesan</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Layanan</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Target</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Harga</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody id="admin-orders-table-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="9" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                            <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data pesanan...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
         <div id="admin-orders-pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
            <div id="admin-orders-pagination-info">Menampilkan 0 hasil.</div>
            <div id="admin-orders-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
        </div>
    </div>

    <div id="admin-order-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="admin-order-filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-3xl mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="admin-order-filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="admin-order-filter-modal-title">
                    <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Pesanan
                </h3>
                <button type="button" id="close-admin-order-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form id="admin-order-filter-form" class="p-6 space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label for="filter_limit_admin_order" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                        <select id="filter_limit_admin_order" name="limit" class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="15" <?php echo ($initialLimit == 15) ? 'selected' : ''; ?>>15 baris</option>
                            <option value="30" <?php echo ($initialLimit == 30) ? 'selected' : ''; ?>>30 baris</option>
                            <option value="50" <?php echo ($initialLimit == 50) ? 'selected' : ''; ?>>50 baris</option>
                            <option value="100" <?php echo ($initialLimit == 100) ? 'selected' : ''; ?>>100 baris</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_status_admin_order" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                        <select id="filter_status_admin_order" name="status" class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($statusOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialStatusFilter === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                     <div>
                        <label for="filter_user_id_admin_order" class="block text-sm font-medium text-gray-300 mb-1">ID Pengguna</label>
                        <input type="number" id="filter_user_id_admin_order" name="user_id" value="<?php echo htmlspecialchars($initialUserId); ?>" placeholder="Kosongkan = Semua"
                               class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
                 <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                     <div>
                        <label for="filter_service_id_admin_order" class="block text-sm font-medium text-gray-300 mb-1">ID Layanan</label>
                        <input type="number" id="filter_service_id_admin_order" name="service_id" value="<?php echo htmlspecialchars($initialServiceId); ?>" placeholder="Kosongkan = Semua"
                               class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                    <div>
                        <label for="filter_date_start_admin_order" class="block text-sm font-medium text-gray-300 mb-1">Tanggal Mulai</label>
                        <input type="date" id="filter_date_start_admin_order" name="date_start" value="<?php echo htmlspecialchars($initialDateStart); ?>" class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                    <div>
                        <label for="filter_date_end_admin_order" class="block text-sm font-medium text-gray-300 mb-1">Tanggal Akhir</label>
                        <input type="date" id="filter_date_end_admin_order" name="date_end" value="<?php echo htmlspecialchars($initialDateEnd); ?>" class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_search_column_admin_order" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                        <select id="filter_search_column_admin_order" name="search_column" class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($searchColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialSearchColumn === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                             <option value="u.username" <?php echo ($initialSearchColumn === 'u.username') ? 'selected' : ''; ?>>Username</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_search_keyword_admin_order" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci</label>
                        <input type="text" id="filter_search_keyword_admin_order" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchQuery); ?>" placeholder="Masukkan kata kunci..."
                               class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                 </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_sort_by_admin_order" class="block text-sm font-medium text-gray-300 mb-1">Urutkan</label>
                        <select id="filter_sort_by_admin_order" name="sort_by" class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($sortColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialSortBy === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                             <option value="u.username" <?php echo ($initialSortBy === 'u.username') ? 'selected' : ''; ?>>Username</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_sort_type_admin_order" class="block text-sm font-medium text-gray-300 mb-1">Tipe</label>
                        <select id="filter_sort_type_admin_order" name="sort_type" class="admin-order-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($sortTypeOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialSortType === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                     <button type="button" id="reset-admin-order-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">Reset</button>
                     <button type="submit" id="apply-admin-order-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition"><i class="fas fa-filter mr-1"></i> Terapkan</button>
                 </div>
            </form>
        </div>
    </div>

     <div id="edit-order-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60">
         <div class="relative bg-white rounded-lg shadow-xl w-full max-w-lg mx-4" id="edit-order-modal-content">
             <div class="flex items-center justify-between p-5 border-b rounded-t">
                 <h3 class="text-xl font-semibold text-gray-900">Edit Pesanan #<span id="edit-order-id-span"></span></h3>
                 <button type="button" id="close-edit-order-modal" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center">
                     <i class="fas fa-times text-xl"></i><span class="sr-only">Tutup</span>
                 </button>
             </div>
             <form id="edit-order-form" class="p-6 space-y-4">
                 <input type="hidden" id="edit_order_id" name="order_id">

                 <div>
                     <label for="edit_order_status" class="block text-sm font-medium text-gray-700 mb-1">Status Pesanan</label>
                     <select id="edit_order_status" name="status" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm bg-white focus:ring-blue-500 focus:border-blue-500">
                         <?php foreach ($statusOptions as $value => $label): ?>
                             <?php if ($value !== 'all'): ?>
                                 <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                             <?php endif; ?>
                         <?php endforeach; ?>
                     </select>
                     <span id="edit_order_status-error" class="text-red-500 text-xs mt-1"></span>
                 </div>

                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="edit_order_start_count" class="block text-sm font-medium text-gray-700 mb-1">Jumlah Awal (Start Count)</label>
                        <input type="number" id="edit_order_start_count" name="start_count" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500" placeholder="Kosongkan jika tidak tahu">
                        <span id="edit_order_start_count-error" class="text-red-500 text-xs mt-1"></span>
                    </div>
                    <div>
                        <label for="edit_order_remains" class="block text-sm font-medium text-gray-700 mb-1">Jumlah Kurang (Remains)</label>
                        <input type="number" id="edit_order_remains" name="remains" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500" placeholder="Kosongkan jika tidak tahu">
                        <span id="edit_order_remains-error" class="text-red-500 text-xs mt-1"></span>
                    </div>
                 </div>
                 <div id="edit-order-message" class="text-sm"></div>
             </form>
              <div class="flex items-center justify-end p-6 space-x-2 border-t border-gray-200 rounded-b">
                 <button id="cancel-edit-order-button" type="button" class="px-5 py-2.5 text-sm font-medium text-gray-500 bg-white rounded-lg border border-gray-200 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200">Batal</button>
                 <button id="save-edit-order-button" type="submit" form="edit-order-form" class="px-5 py-2.5 text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    Simpan Perubahan
                 </button>
             </div>
         </div>
     </div>

</main>
