<?php
global $logLoginStatusOptions, $logLoginSortColumnOptions, $logLoginSortTypeOptions, $logLoginSearchColumnOptions;

$logLoginStatusOptions = [
    'all' => 'Semua Status', 
    'success' => 'Sukses', 
    'failed_password' => 'Gagal (Password Salah)', 
    'failed_username' => 'Gagal (Username Salah)',
    'admin_impersonate_start' => 'Impersonate Mulai',
    'admin_impersonate_end' => 'Impersonate Selesai'
];
$logLoginSortColumnOptions = [
    'll.login_at' => 'Waktu Login',
    'll.id' => 'ID Log',
    'u.username' => 'Username',
    'll.username_attempt' => 'Username Percobaan',
    'll.ip_address' => 'IP Address',
    'll.status' => 'Status'
];
$logLoginSortTypeOptions = ['DESC' => 'Terbaru/Tertinggi', 'ASC' => 'Terlama/Terendah'];
$logLoginSearchColumnOptions = [
    'll.id' => 'ID Log',
    'u.username' => 'Username Pengguna',
    'll.username_attempt' => 'Username Percobaan',
    'll.ip_address' => 'IP Address',
    'll.user_agent' => 'User Agent',
    'll.location_info' => 'Lokasi'
];

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-history mr-3 text-purple-500"></i> Log Masuk Pengguna & Admin
        </h2>
        <div class="flex items-center space-x-2">
             <button type="button" id="admin-login-log-filter-modal-button"
                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                <i class="fas fa-filter mr-1"></i> Filter & Cari
            </button>
        </div>
    </div>

    <div id="admin-login-logs-message" class="mb-4 text-sm"></div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden flex flex-col flex-grow">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Username</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Waktu Login</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">IP Address</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden md:table-cell">Perangkat</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden lg:table-cell">Browser & OS</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden md:table-cell">Lokasi</th>
                        <th scope="col" class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody id="admin-login-logs-table-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="8" class="px-6 py-24 text-center text-sm text-gray-500 italic">
                            <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data log masuk...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
         <div id="admin-login-logs-pagination-container" class="mt-auto px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
            <div id="admin-login-logs-pagination-info">Menampilkan 0 hasil.</div>
            <div id="admin-login-logs-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
        </div>
    </div>

    <div id="admin-login-log-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="admin-login-log-filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-2xl mx-auto transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="admin-login-log-filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="admin-login-log-filter-modal-title">
                    <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Log Masuk
                </h3>
                <button type="button" id="close-admin-login-log-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form id="admin-login-log-filter-form" class="p-6 space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_limit_admin_login_log" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                        <select id="filter_limit_admin_login_log" name="limit" class="admin-login-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="15" selected>15 baris</option>
                            <option value="30">30 baris</option>
                            <option value="50">50 baris</option>
                            <option value="100">100 baris</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_status_admin_login_log" class="block text-sm font-medium text-gray-300 mb-1">Status Login</label>
                        <select id="filter_status_admin_login_log" name="status" class="admin-login-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($logLoginStatusOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_user_id_admin_login_log" class="block text-sm font-medium text-gray-300 mb-1">ID Pengguna</label>
                        <input type="number" id="filter_user_id_admin_login_log" name="user_id" placeholder="Kosongkan = Semua"
                               class="admin-login-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                     <div>
                        <label for="filter_ip_address_admin_login_log" class="block text-sm font-medium text-gray-300 mb-1">Alamat IP</label>
                        <input type="text" id="filter_ip_address_admin_login_log" name="ip_address" placeholder="e.g., 192.168.1.1"
                               class="admin-login-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_search_column_admin_login_log" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                        <select id="filter_search_column_admin_login_log" name="search_column" class="admin-login-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($logLoginSearchColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_search_keyword_admin_login_log" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci</label>
                        <input type="text" id="filter_search_keyword_admin_login_log" name="search_keyword" placeholder="Masukkan kata kunci..."
                               class="admin-login-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                 </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_sort_by_admin_login_log" class="block text-sm font-medium text-gray-300 mb-1">Urutkan</label>
                        <select id="filter_sort_by_admin_login_log" name="sort_by" class="admin-login-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($logLoginSortColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'll.login_at') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_sort_type_admin_login_log" class="block text-sm font-medium text-gray-300 mb-1">Tipe Urutan</label>
                        <select id="filter_sort_type_admin_login_log" name="sort_type" class="admin-login-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($logLoginSortTypeOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'DESC') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                     <button type="button" id="reset-admin-login-log-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">Reset</button>
                     <button type="submit" id="apply-admin-login-log-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition"><i class="fas fa-filter mr-1"></i> Terapkan</button>
                 </div>
            </form>
        </div>
    </div>
</main>
