<?php
$pageTitle = 'Kelola Deposit';
if (!Auth::isLoggedIn() || $_SESSION['user_role'] !== 'admin') {
    redirect(base_url('login'));
}

$initialStatusFilter = $_GET['status'] ?? 'all';
$initialSearchQuery = $_GET['search_keyword'] ?? '';
$initialSearchColumn = $_GET['search_column'] ?? 'd.deposit_id';
$initialLimit = $_GET['limit'] ?? 15;
$initialSortBy = $_GET['sort_by'] ?? 'd.created_at';
$initialSortType = $_GET['sort_type'] ?? 'DESC';
$initialDateStart = $_GET['date_start'] ?? '';
$initialDateEnd = $_GET['date_end'] ?? '';
$initialUserId = $_GET['user_id'] ?? '';
$initialMethodId = $_GET['method_id'] ?? '';

$depositStatusOptionsAdmin = [
    'all' => 'Semua Status',
    'pending' => 'Pending',
    'success' => 'Success',
    'failed' => 'Failed',
    'expired' => 'Expired',
    'canceled' => 'Canceled'
];

$depositSearchColumnOptionsAdmin = [
    'd.deposit_id' => 'ID Deposit',
    'd.paydisini_unique_code' => 'Kode Unik Gateway',
    'u.username' => 'Username Pengguna',
    'u.id' => 'ID Pengguna',
    'dm.name' => 'Nama Metode'
];

$depositSortColumnOptionsAdmin = [
    'd.created_at' => 'Tgl Dibuat',
    'd.updated_at' => 'Tgl Diperbarui',
    'd.deposit_id' => 'ID Deposit',
    'u.username' => 'Username',
    'dm.name' => 'Metode',
    'd.amount' => 'Jumlah',
    'd.status' => 'Status'
];

$depositSortTypeOptionsAdmin = ['DESC' => 'Terbaru/Tertinggi', 'ASC' => 'Terlama/Terendah'];

$depositMethodsForFilter = [];
try {
    if (isset($pdo) && $pdo instanceof PDO) {
        $stmtMethods = $pdo->query("SELECT id, name FROM deposit_methods ORDER BY name ASC");
        $depositMethodsForFilter = $stmtMethods->fetchAll(PDO::FETCH_ASSOC);
    }
} catch (\PDOException $e) {
    error_log("Error fetching deposit methods for filter: " . $e->getMessage());
}

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-coins mr-3 text-yellow-500"></i> Kelola Deposit
        </h2>
        <div class="flex items-center space-x-2">
             <button type="button" id="admin-deposit-filter-modal-button"
                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                <i class="fas fa-filter mr-1"></i> Filter & Cari
            </button>
        </div>
    </div>

    <div id="admin-deposits-message" class="mb-4 text-sm"></div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID Deposit</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pengguna</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Dibuat</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Metode</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Bonus</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Diterima</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody id="admin-deposits-table-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="9" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                            <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data deposit...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
         <div id="admin-deposits-pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
            <div id="admin-deposits-pagination-info">Menampilkan 0 hasil.</div>
            <div id="admin-deposits-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
        </div>
    </div>

    <div id="admin-deposit-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="admin-deposit-filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-3xl mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="admin-deposit-filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="admin-deposit-filter-modal-title">
                    <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Deposit
                </h3>
                <button type="button" id="close-admin-deposit-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form id="admin-deposit-filter-form" class="p-6 space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label for="filter_limit_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                        <select id="filter_limit_admin_deposit" name="limit" class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="15" <?php echo ($initialLimit == 15) ? 'selected' : ''; ?>>15 baris</option>
                            <option value="30" <?php echo ($initialLimit == 30) ? 'selected' : ''; ?>>30 baris</option>
                            <option value="50" <?php echo ($initialLimit == 50) ? 'selected' : ''; ?>>50 baris</option>
                            <option value="100" <?php echo ($initialLimit == 100) ? 'selected' : ''; ?>>100 baris</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_status_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                        <select id="filter_status_admin_deposit" name="status" class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($depositStatusOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialStatusFilter === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                     <div>
                        <label for="filter_user_id_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">ID Pengguna</label>
                        <input type="number" id="filter_user_id_admin_deposit" name="user_id" value="<?php echo htmlspecialchars($initialUserId); ?>" placeholder="Kosongkan = Semua"
                               class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
                 <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                     <div>
                        <label for="filter_method_id_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Metode Pembayaran</label>
                        <select id="filter_method_id_admin_deposit" name="method_id" class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="">Semua Metode</option>
                            <?php foreach ($depositMethodsForFilter as $method): ?>
                                <option value="<?php echo $method['id']; ?>" <?php echo ($initialMethodId == $method['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($method['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_date_start_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Tanggal Mulai</label>
                        <input type="date" id="filter_date_start_admin_deposit" name="date_start" value="<?php echo htmlspecialchars($initialDateStart); ?>" class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                    <div>
                        <label for="filter_date_end_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Tanggal Akhir</label>
                        <input type="date" id="filter_date_end_admin_deposit" name="date_end" value="<?php echo htmlspecialchars($initialDateEnd); ?>" class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_search_column_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                        <select id="filter_search_column_admin_deposit" name="search_column" class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($depositSearchColumnOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialSearchColumn === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_search_keyword_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci</label>
                        <input type="text" id="filter_search_keyword_admin_deposit" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchQuery); ?>" placeholder="Masukkan kata kunci..."
                               class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                 </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_sort_by_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Urutkan</label>
                        <select id="filter_sort_by_admin_deposit" name="sort_by" class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($depositSortColumnOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialSortBy === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_sort_type_admin_deposit" class="block text-sm font-medium text-gray-300 mb-1">Tipe</label>
                        <select id="filter_sort_type_admin_deposit" name="sort_type" class="admin-deposit-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($depositSortTypeOptionsAdmin as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($initialSortType === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                     <button type="button" id="reset-admin-deposit-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">Reset</button>
                     <button type="submit" id="apply-admin-deposit-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition"><i class="fas fa-filter mr-1"></i> Terapkan</button>
                 </div>
            </form>
        </div>
    </div>

     <div id="edit-deposit-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60">
         <div class="relative bg-white rounded-lg shadow-xl w-full max-w-lg mx-4" id="edit-deposit-modal-content">
             <div class="flex items-center justify-between p-5 border-b rounded-t">
                 <h3 class="text-xl font-semibold text-gray-900">Edit Deposit #<span id="edit-deposit-id-span"></span></h3>
                 <button type="button" id="close-edit-deposit-modal" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center">
                     <i class="fas fa-times text-xl"></i><span class="sr-only">Tutup</span>
                 </button>
             </div>
             <form id="edit-deposit-form" class="p-6 space-y-4">
                 <input type="hidden" id="edit_deposit_id" name="deposit_id">
                 <input type="hidden" id="edit_deposit_user_id" name="user_id">
                 <input type="hidden" id="edit_deposit_received_amount" name="received_amount">
                 <input type="hidden" id="edit_deposit_current_status" name="current_status">

                 <div>
                     <label for="edit_deposit_status" class="block text-sm font-medium text-gray-700 mb-1">Status Deposit</label>
                     <select id="edit_deposit_status" name="status" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm bg-white focus:ring-blue-500 focus:border-blue-500">
                         <?php foreach ($depositStatusOptionsAdmin as $value => $label): ?>
                             <?php if ($value !== 'all'): ?>
                                 <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                             <?php endif; ?>
                         <?php endforeach; ?>
                     </select>
                     <span id="edit_deposit_status-error" class="text-red-500 text-xs mt-1"></span>
                 </div>
                 <p class="text-xs text-gray-500">Mengubah status menjadi 'Success' akan otomatis menambahkan saldo ke pengguna. Deposit yang sudah 'Success' tidak bisa diubah ke status lain.</p>
                 <div id="edit-deposit-message" class="text-sm"></div>
             </form>
              <div class="flex items-center justify-end p-6 space-x-2 border-t border-gray-200 rounded-b">
                 <button id="cancel-edit-deposit-button" type="button" class="px-5 py-2.5 text-sm font-medium text-gray-500 bg-white rounded-lg border border-gray-200 hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200">Batal</button>
                 <button id="save-edit-deposit-button" type="submit" form="edit-deposit-form" class="px-5 py-2.5 text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    Simpan Perubahan
                 </button>
             </div>
         </div>
     </div>
</main>
