<?php
    $pageTitle = 'Kelola Kategori Layanan';
    if (!Auth::isLoggedIn() || $_SESSION['user_role'] !== 'admin') { redirect(base_url('login')); }

    $initialStatusFilter = $_GET['status'] ?? 'all';
    $initialSearchQuery = $_GET['search'] ?? '';
    $initialLimit = $_GET['limit'] ?? 15;

    $statusOptionsCategories = [
        'all' => 'Semua Status',
        'active' => 'Aktif',
        'inactive' => 'Nonaktif',
    ];
     $searchColumnOptionsCategories = [
        'id' => 'ID Kategori',
        'name' => 'Nama Kategori',
    ];
     $sortColumnOptionsCategories = [
        'name' => 'Nama Kategori',
        'id' => 'ID Kategori',
        'created_at' => 'Tgl Dibuat',
        'status' => 'Status'
    ];
    $sortTypeOptionsCategories = ['ASC' => 'A-Z / Terlama', 'DESC' => 'Z-A / Terbaru'];


    ?>
    <main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
            <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
                <i class="fas fa-tags mr-3 text-indigo-500"></i> Kelola Kategori Layanan
            </h2>
            <div class="flex items-center space-x-2">
                 <button type="button" id="admin-category-filter-modal-button"
                        class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                    <i class="fas fa-filter mr-1"></i> Filter
                </button>
                <button type="button" id="add-category-button"
                   class="px-4 py-2 text-sm font-medium text-white bg-green-600 rounded-lg shadow hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition">
                    <i class="fas fa-plus mr-1"></i> Tambah Kategori
                </button>
            </div>
        </div>

        <div id="admin-categories-message" class="mb-4 text-sm"></div>

        <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                            <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Ikon</th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Kategori</th>
                            <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Dibuat</th>
                            <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                        </tr>
                    </thead>
                    <tbody id="admin-categories-table-body" class="bg-white divide-y divide-gray-200">
                        <tr>
                            <td colspan="6" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                                <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data kategori...
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
             <div id="admin-categories-pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
                <div id="admin-categories-pagination-info">Menampilkan 0 hasil.</div>
                <div id="admin-categories-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
            </div>
        </div>

        <div id="admin-category-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="admin-category-filter-modal-title" role="dialog" aria-modal="true">
            <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-xl mx-auto transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="admin-category-filter-modal-content">
                <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="admin-category-filter-modal-title">
                        <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Kategori
                    </h3>
                    <button type="button" id="close-admin-category-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                        <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                <form id="admin-category-filter-form" class="p-6 space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="filter_limit_admin_category" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                            <select id="filter_limit_admin_category" name="limit" class="admin-category-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <option value="15" <?php echo ($initialLimit == 15) ? 'selected' : ''; ?>>15 baris</option>
                                <option value="30" <?php echo ($initialLimit == 30) ? 'selected' : ''; ?>>30 baris</option>
                                <option value="50" <?php echo ($initialLimit == 50) ? 'selected' : ''; ?>>50 baris</option>
                                <option value="100" <?php echo ($initialLimit == 100) ? 'selected' : ''; ?>>100 baris</option>
                            </select>
                        </div>
                        <div>
                            <label for="filter_status_admin_category" class="block text-sm font-medium text-gray-300 mb-1">Status</label>
                            <select id="filter_status_admin_category" name="status" class="admin-category-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <?php foreach ($statusOptionsCategories as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($initialStatusFilter === $value) ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="filter_search_column_admin_category" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                            <select id="filter_search_column_admin_category" name="search_column" class="admin-category-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <?php foreach ($searchColumnOptionsCategories as $value => $label): ?>
                                    <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="filter_search_keyword_admin_category" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci</label>
                            <input type="text" id="filter_search_keyword_admin_category" name="search_keyword" value="<?php echo htmlspecialchars($initialSearchQuery); ?>" placeholder="Masukkan kata kunci..."
                                   class="admin-category-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="filter_sort_by_admin_category" class="block text-sm font-medium text-gray-300 mb-1">Urutkan</label>
                            <select id="filter_sort_by_admin_category" name="sort_by" class="admin-category-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <?php foreach ($sortColumnOptionsCategories as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($value === 'name') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <label for="filter_sort_type_admin_category" class="block text-sm font-medium text-gray-300 mb-1">Tipe</label>
                            <select id="filter_sort_type_admin_category" name="sort_type" class="admin-category-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                                <?php foreach ($sortTypeOptionsCategories as $value => $label): ?>
                                    <option value="<?php echo $value; ?>" <?php echo ($value === 'ASC') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                        <button type="button" id="reset-admin-category-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">Reset</button>
                        <button type="submit" id="apply-admin-category-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition"><i class="fas fa-filter mr-1"></i> Terapkan</button>
                    </div>
                </form>
            </div>
        </div>

        <div id="add-edit-category-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="add-edit-category-modal-title" role="dialog" aria-modal="true">
            <div class="relative bg-white rounded-xl shadow-xl w-full max-w-lg transform transition-all duration-300 ease-in-out scale-95 opacity-0 flex flex-col max-h-[90vh]" id="add-edit-category-modal-content">
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t flex-shrink-0">
                    <h3 id="add-edit-category-modal-title" class="text-xl font-semibold text-gray-900 flex items-center">
                        <i class="fas fa-plus-circle mr-3 text-green-500"></i> Tambah Kategori Baru
                    </h3>
                    <button type="button" id="close-add-edit-category-modal" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center">
                        <i class="fas fa-times text-xl"></i>
                        <span class="sr-only">Tutup modal</span>
                    </button>
                </div>
                <div class="p-4 md:p-5 space-y-4 overflow-y-auto flex-grow">
                    <form id="add-edit-category-form" class="space-y-4">
                        <input type="hidden" id="category_id" name="category_id" value="">
                        <div>
                            <label for="category_name" class="block mb-1 text-sm font-medium text-gray-700">Nama Kategori <span class="text-red-500">*</span></label>
                            <input type="text" id="category_name" name="name" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                            <span id="category_name-error" class="text-red-500 text-xs mt-1"></span>
                        </div>
                        <div>
                            <label for="category_icon_class" class="block mb-1 text-sm font-medium text-gray-700">Kelas Ikon (Font Awesome)</label>
                            <input type="text" id="category_icon_class" name="icon_class" placeholder="Contoh: fas fa-star, fab fa-instagram" class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm focus:ring-blue-500 focus:border-blue-500">
                            <span id="category_icon_class-error" class="text-red-500 text-xs mt-1"></span>
                            <p class="text-xs text-gray-400 mt-1">Gunakan kelas dari <a href="https://fontawesome.com/v5/search" target="_blank" class="text-blue-500 hover:underline">Font Awesome 5</a>. Kosongkan untuk ikon default.</p>
                        </div>
                        <div>
                            <label for="category_status" class="block mb-1 text-sm font-medium text-gray-700">Status <span class="text-red-500">*</span></label>
                            <select id="category_status" name="status" required class="input-field w-full px-3 py-2 border border-gray-300 rounded-lg sm:text-sm bg-white focus:ring-blue-500 focus:border-blue-500">
                                <option value="active" selected>Aktif</option>
                                <option value="inactive">Nonaktif</option>
                            </select>
                            <span id="category_status-error" class="text-red-500 text-xs mt-1"></span>
                        </div>
                        <div id="add-edit-category-message" class="text-sm"></div>
                    </form>
                </div>
                <div class="flex items-center justify-end p-4 md:p-5 space-x-3 rtl:space-x-reverse border-t border-gray-200 rounded-b flex-shrink-0">
                    <button id="cancel-add-edit-category-button" type="button" class="py-2.5 px-5 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-100">Batal</button>
                    <button id="save-add-edit-category-button" type="submit" form="add-edit-category-form" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center">
                        Simpan Kategori
                    </button>
                </div>
            </div>
        </div>

        <div id="delete-category-confirm-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out" aria-labelledby="delete-category-confirm-modal-title" role="dialog" aria-modal="true">
            <div class="relative bg-white rounded-lg shadow-xl w-full max-w-md mx-4 transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="delete-category-confirm-modal-content">
                 <div class="flex items-center justify-between p-5 border-b rounded-t">
                     <h3 id="delete-category-confirm-modal-title" class="text-xl font-semibold text-gray-900 flex items-center">
                        <i class="fas fa-exclamation-triangle text-red-500 mr-3"></i> Konfirmasi Hapus
                     </h3>
                     <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center close-confirm-delete-category-btn">
                         <i class="fas fa-times text-xl"></i><span class="sr-only">Tutup</span>
                     </button>
                 </div>
                 <div class="p-6 text-center">
                     <i class="fas fa-trash-alt text-4xl text-red-400 mb-4"></i>
                     <p id="delete-category-confirm-modal-message" class="mb-5 text-lg font-normal text-gray-600">Apakah Anda yakin ingin menghapus kategori ini?</p>
                     <p class="text-xs text-red-600 mb-4">(Menghapus kategori juga akan menghapus semua layanan di dalamnya!)</p>
                     <button type="button" class="text-white bg-red-600 hover:bg-red-800 focus:ring-4 focus:outline-none focus:ring-red-300 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center mr-2" id="confirm-delete-category-btn">
                         Ya, Hapus
                     </button>
                     <button type="button" class="text-gray-500 bg-white hover:bg-gray-100 focus:ring-4 focus:outline-none focus:ring-gray-200 rounded-lg border border-gray-200 text-sm font-medium px-5 py-2.5 hover:text-gray-900 focus:z-10 close-confirm-delete-category-btn">
                         Batal
                     </button>
                 </div>
            </div>
        </div>

    </main>
    