<?php
$pageTitle = 'Mutasi Saldo Pengguna';
if (!Auth::isLoggedIn() || $_SESSION['user_role'] !== 'admin') {
    redirect(base_url('login'));
}

// Opsi filter (bisa didefinisikan di sini atau diambil dari controller/AJAX handler)
$logTypeOptions = ['all' => 'Semua Tipe', 'credit' => 'Kredit', 'debit' => 'Debit'];
$logCategoryOptions = [
    'all' => 'Semua Kategori',
    'deposit' => 'Deposit',
    'order_placement' => 'Pembuatan Pesanan',
    'order_refund' => 'Refund Pesanan',
    'admin_adjustment' => 'Penyesuaian Admin',
    'other' => 'Lainnya'
];
$logSortColumnOptions = [
    'bl.created_at' => 'Tanggal Dibuat',
    'bl.id' => 'ID Log',
    'u.username' => 'Username',
    'bl.type' => 'Tipe',
    'bl.category' => 'Kategori',
    'bl.amount' => 'Jumlah'
];
$logSortTypeOptions = ['DESC' => 'Terbaru/Tertinggi', 'ASC' => 'Terlama/Terendah'];
$logSearchColumnOptions = [
    'bl.id' => 'ID Log',
    'u.username' => 'Username Pengguna',
    'bl.description' => 'Deskripsi',
    'bl.reference_id' => 'ID Referensi'
];

?>
<main class="flex-1 overflow-x-hidden overflow-y-auto p-6 md:p-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h2 class="text-2xl font-semibold text-gray-700 flex items-center">
            <i class="fas fa-exchange-alt mr-3 text-green-500"></i> Mutasi Saldo Pengguna
        </h2>
        <div class="flex items-center space-x-2">
             <button type="button" id="admin-balance-log-filter-modal-button"
                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition">
                <i class="fas fa-filter mr-1"></i> Filter & Cari
            </button>
        </div>
    </div>

    <div id="admin-balance-logs-message" class="mb-4 text-sm"></div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Username</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Dibuat</th>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider hidden md:table-cell">Asal</th>
                        <th scope="col" class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Tipe</th>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kategori</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Jumlah</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider hidden sm:table-cell">Saldo Sebelum</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Saldo Akhir</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Deskripsi</th>
                    </tr>
                </thead>
                <tbody id="admin-balance-logs-table-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="10" class="px-6 py-10 text-center text-sm text-gray-500 italic">
                            <i class="fas fa-spinner fa-spin mr-2"></i> Memuat data mutasi saldo...
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
         <div id="admin-balance-logs-pagination-container" class="px-4 py-3 border-t border-gray-200 bg-gray-50 text-xs text-gray-600 flex flex-col sm:flex-row justify-between items-center">
            <div id="admin-balance-logs-pagination-info">Menampilkan 0 hasil.</div>
            <div id="admin-balance-logs-pagination-controls" class="flex justify-end mt-2 sm:mt-0 space-x-1"></div>
        </div>
    </div>

    <div id="admin-balance-log-filter-modal" class="fixed inset-0 z-50 hidden items-center justify-center bg-black bg-opacity-60 transition-opacity duration-300 ease-in-out p-4" aria-labelledby="admin-balance-log-filter-modal-title" role="dialog" aria-modal="true">
        <div class="relative bg-gray-800 rounded-lg shadow-xl w-full max-w-2xl mx-auto transform transition-all duration-300 ease-in-out scale-95 opacity-0" id="admin-balance-log-filter-modal-content">
            <div class="flex items-center justify-between px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-gray-100 flex items-center" id="admin-balance-log-filter-modal-title">
                    <i class="fas fa-filter mr-2 text-blue-400"></i> Filter Mutasi Saldo
                </h3>
                <button type="button" id="close-admin-balance-log-filter-modal" class="text-gray-400 hover:text-white focus:outline-none">
                    <span class="sr-only">Tutup</span><i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <form id="admin-balance-log-filter-form" class="p-6 space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label for="filter_limit_admin_log" class="block text-sm font-medium text-gray-300 mb-1">Tampilkan</label>
                        <select id="filter_limit_admin_log" name="limit" class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="15" selected>15 baris</option>
                            <option value="30">30 baris</option>
                            <option value="50">50 baris</option>
                            <option value="100">100 baris</option>
                        </select>
                    </div>
                    <div>
                        <label for="filter_type_admin_log" class="block text-sm font-medium text-gray-300 mb-1">Tipe</label>
                        <select id="filter_type_admin_log" name="type" class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($logTypeOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                     <div>
                        <label for="filter_category_admin_log" class="block text-sm font-medium text-gray-300 mb-1">Kategori</label>
                        <select id="filter_category_admin_log" name="category" class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($logCategoryOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_user_id_admin_log" class="block text-sm font-medium text-gray-300 mb-1">ID Pengguna</label>
                        <input type="number" id="filter_user_id_admin_log" name="user_id" placeholder="Kosongkan = Semua"
                               class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                    <div>
                        <label for="filter_source_admin_log" class="block text-sm font-medium text-gray-300 mb-1">Asal</label>
                        <select id="filter_source_admin_log" name="source" class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <option value="all">Semua Asal</option>
                            <option value="web">Web</option>
                            <option value="api">API</option>
                            <option value="cron">Cron</option>
                            <option value="admin">Admin</option>
                            <option value="callback">Callback</option>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_search_column_admin_log" class="block text-sm font-medium text-gray-300 mb-1">Kolom Cari</label>
                        <select id="filter_search_column_admin_log" name="search_column" class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($logSearchColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>"><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_search_keyword_admin_log" class="block text-sm font-medium text-gray-300 mb-1">Kata Kunci</label>
                        <input type="text" id="filter_search_keyword_admin_log" name="search_keyword" placeholder="Masukkan kata kunci..."
                               class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                    </div>
                 </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="filter_sort_by_admin_log" class="block text-sm font-medium text-gray-300 mb-1">Urutkan</label>
                        <select id="filter_sort_by_admin_log" name="sort_by" class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                            <?php foreach ($logSortColumnOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'bl.created_at') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="filter_sort_type_admin_log" class="block text-sm font-medium text-gray-300 mb-1">Tipe</label>
                        <select id="filter_sort_type_admin_log" name="sort_type" class="admin-log-filter-input w-full px-3 py-2 text-sm bg-gray-700 border border-gray-600 text-gray-100 rounded-lg focus:outline-none focus:ring-1 focus:ring-blue-500 focus:border-blue-500">
                             <?php foreach ($logSortTypeOptions as $value => $label): ?>
                                <option value="<?php echo $value; ?>" <?php echo ($value === 'DESC') ? 'selected' : ''; ?>><?php echo htmlspecialchars($label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                 <div class="flex justify-end items-center pt-4 space-x-3 border-t border-gray-700 mt-5">
                     <button type="button" id="reset-admin-balance-log-filter-button" class="px-4 py-2 text-sm font-medium text-gray-300 bg-gray-600 rounded-lg hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-gray-500 transition">Reset</button>
                     <button type="submit" id="apply-admin-balance-log-filter-button" class="px-5 py-2 text-sm font-medium text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-800 focus:ring-blue-500 transition"><i class="fas fa-filter mr-1"></i> Terapkan</button>
                 </div>
            </form>
        </div>
    </div>
</main>
