<?php
    header('Content-Type: application/json');
    $response = ['success' => false, 'message' => 'Gagal menghapus informasi.'];

    require_once __DIR__ . '/../../../config/config.php';
    require_once __DIR__ . '/../../../includes/session.php';
    require_once __DIR__ . '/../../../lib/Auth.php';
    require_once __DIR__ . '/../../../includes/functions.php';

    if (!Auth::isLoggedIn() || $_SESSION['user_role'] !== 'admin') {
        http_response_code(403);
        $response['message'] = 'Akses ditolak.';
        echo json_encode($response);
        exit;
    }

    if (!isset($pdo) || !$pdo instanceof PDO) {
        http_response_code(500);
        error_log("PDO object not available in admin/delete_information.php");
        $response['message'] = 'Koneksi database gagal.';
        echo json_encode($response);
        exit;
    }

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        http_response_code(405);
        $response['message'] = 'Metode request tidak valid.';
        echo json_encode($response);
        exit;
    }

    define('UPLOAD_DIR', PUBLIC_ROOT . '/uploads/informations/');

    $requestData = json_decode(file_get_contents('php://input'), true);
    $infoIdToDelete = filter_var($requestData['info_id'] ?? null, FILTER_VALIDATE_INT);

    if (!$infoIdToDelete) {
        http_response_code(400);
        $response['message'] = 'ID informasi tidak valid.';
        echo json_encode($response);
        exit;
    }

    try {
        $stmtSelect = $pdo->prepare("SELECT image_filename FROM informations WHERE id = :id");
        $stmtSelect->bindParam(':id', $infoIdToDelete, PDO::PARAM_INT);
        $stmtSelect->execute();
        $imageFilename = $stmtSelect->fetchColumn();

        $sql = "DELETE FROM informations WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $infoIdToDelete, PDO::PARAM_INT);

        if ($stmt->execute()) {
            if ($stmt->rowCount() > 0) {
                if ($imageFilename && file_exists(UPLOAD_DIR . $imageFilename)) {
                    unlink(UPLOAD_DIR . $imageFilename);
                }
                $response['success'] = true;
                $response['message'] = "Informasi (ID: {$infoIdToDelete}) berhasil dihapus.";
            } else {
                 http_response_code(404); 
                 $response['message'] = 'Informasi tidak ditemukan.';
            }
        } else {
            http_response_code(500);
            $response['message'] = 'Gagal menghapus informasi dari database.';
        }
    } catch (\PDOException $e) {
        error_log("Admin Delete Information DB Error: " . $e->getMessage());
        $response['message'] = "Terjadi kesalahan database.";
        http_response_code(500);
    } catch (\Throwable $e) {
        error_log("Admin Delete Information General Error: " . $e->getMessage());
        $response['message'] = "Terjadi kesalahan internal server.";
        if (defined('DEBUG_MODE') && DEBUG_MODE === true) { $response['debug_php'] = $e->getMessage(); }
        http_response_code(500);
    }

    echo json_encode($response);
    exit;
    ?>
    